package com.artfess.cqxy.designEstimate.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 设计概算 - 水保表(BizAquaticProtection)表实体类
 * @author 黎沐华
 * @since 2022-02-16 15:12:08
 */
@Data
@TableName("biz_aquatic_protection")
@ApiModel(value="设计概算-水保对象-AquaticProtection", description="水保表")
public class AquaticProtection extends BizModel<AquaticProtection> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    private String name;

    @Excel(name = "编号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "编号")
    private String documentNumber;

    @Excel(name = "审查日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "审查日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

    @Excel(name = "审查单位")
    @TableField("REVIEW_UNIT_")
    @ApiModelProperty(value = "审查单位")
    private String reviewUnit;

    @Excel(name = "结论")
    @TableField("CONCLUSION_")
    @ApiModelProperty(value = "结论")
    private String conclusion;

    @Excel(name = "建议")
    @TableField("PROPOSAL_")
    @ApiModelProperty(value = "建议")
    private String proposal;

    @Excel(name = "审查意见")
    @TableField("REVIEW_COMMENTS_")
    @ApiModelProperty(value = "审查意见")
    private String reviewComments;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "AquaticProtection{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", name='" + name + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", reviewUnit='" + reviewUnit + '\'' +
                ", conclusion='" + conclusion + '\'' +
                ", proposal='" + proposal + '\'' +
                ", reviewComments='" + reviewComments + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

