package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.ledger.manager.PayLedgerManager;
import com.artfess.cqxy.ledger.vo.PayLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author 黎沐华
 * @date 2022/6/2 9:55
 */
@Slf4j
@RestController
@Api(tags = "台账-项目支付台账接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/ledger/pay/v1")
public class PayLedgerController {

    @Autowired
    private PayLedgerManager manager;

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据", httpMethod = "POST")
    public CommonResult<PageList<PayLedgerVo>> page(@ApiParam(name = "queryFilter",value = "查询器") @RequestBody QueryFilter<PayLedgerVo> queryFilter) {
        PageList<PayLedgerVo> result = manager.queryByPage(queryFilter);
        return new CommonResult<>(true, "操作成功", result);
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "S-导出数据到Excel")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "查询器")@RequestBody QueryFilter<PayLedgerVo> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("导出数据到Excel接口请求参数：{}",queryFilter,response);
        manager.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    @PostMapping("/totalPayByYear")
    @ApiOperation(value = "S-年度总支付",notes = "传入年份 year")
    public CommonResult totalPayByYear (
            @ApiParam(name = "year",value = "统计年份")@RequestParam Integer year){
        BigDecimal result = manager.totalPayByYear(year);
        return new CommonResult<>(true, "操作成功", result);
    }

}
