/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.cloud.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.accessory.manager.AccessoryManager;
import com.artfess.rescue.accessory.model.Accessory;
import com.artfess.rescue.cloud.dao.BizCloudApplyDao;
import com.artfess.rescue.cloud.dto.CloudApplyAndSaveDTO;
import com.artfess.rescue.cloud.dto.CloudApplyPortDTO;
import com.artfess.rescue.cloud.dto.CloudApplySaveDTO;
import com.artfess.rescue.cloud.enums.CloudApplyStatusEnum;
import com.artfess.rescue.cloud.manager.BizCloudApplyApprovalRecordManager;
import com.artfess.rescue.cloud.manager.BizCloudApplyDetailManager;
import com.artfess.rescue.cloud.manager.BizCloudApplyManager;
import com.artfess.rescue.cloud.manager.BizCloudApplyUseDetailedManager;
import com.artfess.rescue.cloud.model.BizCloudApply;
import com.artfess.rescue.cloud.model.BizCloudApplyUseDetailed;
import com.artfess.rescue.cloud.vo.CloudApplyExportVO;
import com.artfess.rescue.context.UserContextUtil;
import com.artfess.rescue.utils.ExcelToPdfUtil;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizCloudApplyManagerImpl
extends BaseManagerImpl<BizCloudApplyDao, BizCloudApply>
implements BizCloudApplyManager {
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    private BizCloudApplyApprovalRecordManager cloudApplyApprovalRecordManager;
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private BaseContext baseContext;
    @Resource
    private UserContextUtil userContextUtil;
    @Resource
    private BizCloudApplyUseDetailedManager cloudApplyUseDetailedManager;
    @Resource
    private BizCloudApplyDetailManager cloudApplyDetailManager;
    private static final String FILE_CODE = "cloudApply";
    private static final String APPLY_CODE = "cloud_code";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> saveInfo(BizCloudApply cloudApply) {
        String applyCode = this.sysIdentityManager.nextId(APPLY_CODE);
        cloudApply.setApplyCode(applyCode);
        cloudApply.setStatus(0);
        boolean result = this.save((Object)cloudApply);
        if (!result) {
            return new CommonResult(false, ResponseErrorEnums.FAIL_OPTION.getMessage(), null);
        }
        if (CollectionUtils.isNotEmpty(cloudApply.getCloudApplyFile())) {
            String sourceId = cloudApply.getId();
            List<Accessory> list = cloudApply.getCloudApplyFile();
            list.forEach(e -> {
                e.setSourceId(sourceId);
                e.setGroup(FILE_CODE);
            });
            this.accessoryManager.saveBatch(list);
        }
        return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), (Object)cloudApply.getId());
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<BizCloudApply> queryInfoPage(QueryFilter<BizCloudApply> queryFilter) {
        List cloudApplies;
        List<String> sourceIds;
        List<Accessory> accessoryList;
        PageList cloudApplyPage = this.query(queryFilter);
        if (CollectionUtils.isNotEmpty((Collection)cloudApplyPage.getRows()) && CollectionUtils.isNotEmpty(accessoryList = this.accessoryManager.getAccessoryBySourceIds(sourceIds = (cloudApplies = cloudApplyPage.getRows()).stream().map(BizCloudApply::getId).collect(Collectors.toList())))) {
            Map<String, List<Accessory>> collect = accessoryList.stream().collect(Collectors.groupingBy(Accessory::getSourceId));
            cloudApplies.forEach(e -> {
                if (collect.containsKey(e.getId())) {
                    List accessories = (List)collect.get(e.getId());
                    e.setCloudApplyFile(accessories);
                }
            });
            cloudApplyPage.setRows(cloudApplies);
        }
        return cloudApplyPage;
    }

    @Override
    @Transactional(readOnly=true)
    public BizCloudApply getInfoById(String id) {
        BizCloudApply bizCloudApply = (BizCloudApply)((Object)this.getById((Serializable)((Object)id)));
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        if (CollectionUtils.isNotEmpty(accessoryList)) {
            bizCloudApply.setCloudApplyFile(accessoryList);
        }
        return bizCloudApply;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> updateInfoById(BizCloudApply cloudApply) {
        boolean result = this.updateById((Object)cloudApply);
        if (!result) {
            return new CommonResult(false, ResponseErrorEnums.FAIL_OPTION.getMessage(), null);
        }
        this.accessoryManager.delAccessoryBySourceId(cloudApply.getId());
        if (CollectionUtils.isNotEmpty(cloudApply.getCloudApplyFile())) {
            String sourceId = cloudApply.getId();
            List<Accessory> list = cloudApply.getCloudApplyFile();
            list.forEach(e -> {
                e.setSourceId(sourceId);
                e.setGroup(FILE_CODE);
            });
            this.accessoryManager.saveBatch(list);
        }
        return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), (Object)cloudApply.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> deleteInfoById(String id) {
        boolean result = this.removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(false, ResponseErrorEnums.FAIL_OPTION.getMessage(), null);
        }
        this.accessoryManager.delAccessoryBySourceId(id);
        this.cloudApplyUseDetailedManager.deleListByCloudApplyId(Collections.singletonList(id));
        return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), (Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> deleteInfoByIds(List<String> ids) {
        boolean result = this.removeByIds(ids);
        if (!result) {
            return new CommonResult(false, ResponseErrorEnums.FAIL_OPTION.getMessage(), null);
        }
        this.accessoryManager.delAccessoryBySourceIds(ids);
        this.cloudApplyUseDetailedManager.deleListByCloudApplyId(ids);
        return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> saveAndApply(CloudApplyAndSaveDTO dto) {
        BizCloudApply cloudApply = dto.getCloudApply();
        CommonResult<String> result = this.saveInfo(cloudApply);
        String cloudApplyId = (String)result.getValue();
        dto.getApprovalRecordDto().setPrivateCloudApplyId(cloudApplyId);
        this.cloudApplyApprovalRecordManager.applyStart(dto.getApprovalRecordDto());
        return result;
    }

    @Override
    public void updateStatus(String id, Integer status, String opinion) {
        BizCloudApply cloudApply = (BizCloudApply)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtil.isNotEmpty((String)opinion) && (CloudApplyStatusEnum.TO_BE_EXECUTE.getStatus().equals(status) || CloudApplyStatusEnum.FAIL_AUDIT.getStatus().equals(status))) {
            cloudApply.setManagerUnitOpinion(opinion);
        }
        if (StringUtil.isNotEmpty((String)opinion) && CloudApplyStatusEnum.TODO.getStatus().equals(status)) {
            cloudApply.setApplyUnitOpinion(opinion);
        }
        cloudApply.setStatus(status);
        this.updateById((Object)cloudApply);
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<BizCloudApply> queryTodoPage(QueryFilter<BizCloudApply> queryFilter) {
        if (this.userContextUtil.isAdmin(this.baseContext.getCurrentUserId())) {
            return this.queryInfoPage(queryFilter);
        }
        for (QueryField query : queryFilter.getQuerys()) {
            List<String> ids;
            if ("STATUS_".equals(query.getProperty()) && CloudApplyStatusEnum.TODO.getStatus().equals(query.getValue())) {
                ids = this.cloudApplyApprovalRecordManager.getApplyIdByApprovalUserId(this.baseContext.getCurrentUserId(), "\u4e3b\u7ba1\u5355\u4f4d\u5ba1\u6838");
                if (!CollectionUtils.isNotEmpty(ids)) continue;
                queryFilter.addFilter("ID_", ids, QueryOP.IN, FieldRelation.AND, "main");
                continue;
            }
            if (!"STATUS_".equals(query.getProperty()) || !CloudApplyStatusEnum.TO_BE_EXECUTE.getStatus().equals(query.getValue()) || !CollectionUtils.isNotEmpty(ids = this.cloudApplyApprovalRecordManager.getApplyIdByApprovalUserId(this.baseContext.getCurrentUserId(), "\u8fd0\u7ef4\u5355\u4f4d\u6267\u884c"))) continue;
            queryFilter.addFilter("ID_", ids, QueryOP.IN, FieldRelation.AND, "main");
        }
        return this.queryInfoPage(queryFilter);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> cloudApplySave(CloudApplySaveDTO dto) {
        BizCloudApply apply = dto.getCloudApply();
        CommonResult<String> result = this.saveInfo(apply);
        String cloudApplyId = (String)result.getValue();
        LocalDateTime createTime = LocalDateTime.now();
        String createName = this.baseContext.getCurrentUserId();
        String createId = this.baseContext.getCurrentUserName();
        dto.getCloudApplyUseDetailedList().forEach(e -> {
            e.setPrivateCloudApplyId(cloudApplyId);
            e.setCreateTime(createTime);
            e.setCreateBy(createId);
            e.setCreateName(createName);
        });
        this.cloudApplyUseDetailedManager.saveList(dto.getCloudApplyUseDetailedList());
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> cloudApplyUpdate(CloudApplySaveDTO dto) {
        CommonResult<String> result = this.updateInfoById(dto.getCloudApply());
        this.cloudApplyUseDetailedManager.updateBatchById(dto.getCloudApplyUseDetailedList());
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public CloudApplySaveDTO getCloudApplyInfo(String id) {
        CloudApplySaveDTO dto = new CloudApplySaveDTO();
        BizCloudApply cloudApply = this.getInfoById(id);
        List<BizCloudApplyUseDetailed> list = this.cloudApplyUseDetailedManager.getListByCloudApplyId(id);
        dto.setCloudApply(cloudApply);
        dto.setCloudApplyUseDetailedList(list);
        return dto;
    }

    @Override
    public void export(String id, HttpServletResponse response) {
        Assert.hasText((String)id, (String)"\u4e91\u8d44\u6e90\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CloudApplyExportVO vo = new CloudApplyExportVO();
        BizCloudApply cloudApply = (BizCloudApply)((Object)this.getById((Serializable)((Object)id)));
        ArrayList<String> value = new ArrayList<String>(Arrays.asList("cloudType", "status", "applyUnitOpinion", "managerUnitOpinion"));
        BeanUtils.copyPropertiesIgnoringField((Object)((Object)cloudApply), (Object)vo, value);
        vo.setCloudType(cloudApply.getCloudType() == 1 ? "XSKY" : "Zstack");
        vo.setStatus(CloudApplyStatusEnum.getValueByStatus(cloudApply.getStatus()));
        if (StringUtil.isNotEmpty((String)cloudApply.getManagerUnitOpinion())) {
            List<String> applyUnitOpinion = Arrays.asList(cloudApply.getApplyUnitOpinion().split("<br/>"));
            vo.setApplyUnitOpinion(applyUnitOpinion.get(0));
            vo.setApplyUnitOpinionTime(applyUnitOpinion.get(applyUnitOpinion.size() - 1));
        }
        if (StringUtil.isNotEmpty((String)cloudApply.getManagerUnitOpinion())) {
            List<String> managerUnitOpinion = Arrays.asList(cloudApply.getManagerUnitOpinion().split("<br/>"));
            vo.setManagerUnitOpinion(managerUnitOpinion.get(0));
            vo.setManagerUnitOpinionUser(managerUnitOpinion.get(managerUnitOpinion.size() - 2));
            vo.setManagerUnitOpinionTime(managerUnitOpinion.get(managerUnitOpinion.size() - 1));
        }
        List<BizCloudApplyUseDetailed> listByCloudApplyId = this.cloudApplyUseDetailedManager.getListByCloudApplyId(id);
        listByCloudApplyId.forEach(e -> this.processCloudApplyUse((BizCloudApplyUseDetailed)((Object)e), vo));
        List<CloudApplyPortDTO> list = this.cloudApplyDetailManager.getCloudApplyPortDTOList(id);
        vo.setList(list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vo", vo);
        String fileName = cloudApply.getApplyUnitContacts() + "\u7684\u79c1\u6709\u4e91\u8d44\u6e90\u7533\u8bf7\u8868";
        TemplateExportParams params = new TemplateExportParams("file/\u79c1\u6709\u4e91\u7533\u8bf7\u8868\u5bfc\u51fa\u6a21\u677f.xlsx", true, new String[0]);
        this.exportExcelToPdf(fileName, params, map, response);
    }

    private void processCloudApplyUse(BizCloudApplyUseDetailed e, CloudApplyExportVO vo) {
        boolean isAfterAllocation;
        boolean isXSKY = e.getCloudType() == 1;
        boolean bl = isAfterAllocation = e.getUseType() == 1;
        if (isXSKY) {
            if (isAfterAllocation) {
                vo.setSufX(e);
            } else {
                vo.setPreX(e);
            }
        } else if (isAfterAllocation) {
            vo.setSufZ(e);
        } else {
            vo.setPreZ(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcelToPdf(String fileName, TemplateExportParams params, Map<String, Object> map, HttpServletResponse response) {
        File tempPdfFile = null;
        File tempExcelFile = null;
        OutputStream os = null;
        try {
            tempExcelFile = File.createTempFile(fileName, ".xlsx");
            tempPdfFile = File.createTempFile(fileName, ".pdf");
            os = Files.newOutputStream(tempExcelFile.toPath(), new OpenOption[0]);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            workbook.write(os);
            ExcelToPdfUtil.excelToPdf(tempExcelFile.getPath(), tempPdfFile.getPath(), false);
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)tempPdfFile.getPath(), (String)(fileName + ".pdf"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25\uff01");
                }
            }
            if (tempExcelFile != null) {
                tempExcelFile.delete();
            }
            if (tempPdfFile != null) {
                tempPdfFile.delete();
            }
        }
    }
}

