/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.video.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.video.dao.BizVideoMonitorPointInfoDao;
import com.artfess.rescue.video.dto.PreviewURLsRequest;
import com.artfess.rescue.video.dto.VideoMonitorPointCountDTO;
import com.artfess.rescue.video.dto.VideoMonitorPointInfoUrlDTO;
import com.artfess.rescue.video.manager.BizVideoMonitorPointInfoManager;
import com.artfess.rescue.video.model.BizVideoMonitorPointInfo;
import com.artfess.rescue.video.util.HkArtemisRequest;
import com.artfess.rescue.video.vo.VideoMonitorPointInfoUrlVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizVideoMonitorPointInfoManagerImpl
extends BaseManagerImpl<BizVideoMonitorPointInfoDao, BizVideoMonitorPointInfo>
implements BizVideoMonitorPointInfoManager {
    @Resource
    private HkArtemisRequest hkArtemisRequest;
    public static final String NW_IP = "172.16.200.100";
    public static final String WW_IP = "183.64.175.153";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSynchronizationInfo(JSONArray jsonArray, Integer type) {
        List bizVideoMonitorPointInfos = jsonArray.toJavaList(BizVideoMonitorPointInfo.class);
        if (CollectionUtils.isNotEmpty((Collection)bizVideoMonitorPointInfos)) {
            if (type == 1) {
                this.addPosAndCarCq(bizVideoMonitorPointInfos);
                if (CollectionUtils.isNotEmpty((Collection)bizVideoMonitorPointInfos)) {
                    bizVideoMonitorPointInfos.forEach(e -> e.setId(e.getGbIndexCode()));
                }
            } else if (type == 2) {
                this.addPosAndCarWs(bizVideoMonitorPointInfos);
                if (CollectionUtils.isNotEmpty((Collection)bizVideoMonitorPointInfos)) {
                    bizVideoMonitorPointInfos.forEach(e -> e.setId(e.getCameraIndexCode()));
                }
            }
            this.saveOrUpdateBatch(bizVideoMonitorPointInfos);
        }
    }

    @Override
    public CommonResult<List<VideoMonitorPointInfoUrlVO>> previewURLs(VideoMonitorPointInfoUrlDTO dto) {
        ArrayList<VideoMonitorPointInfoUrlVO> urlVOs = new ArrayList<VideoMonitorPointInfoUrlVO>();
        for (String monitorPointInfoId : dto.getMonitorPointInfoIds()) {
            VideoMonitorPointInfoUrlVO vo = new VideoMonitorPointInfoUrlVO();
            PreviewURLsRequest request = new PreviewURLsRequest();
            request.setCameraIndexCode(monitorPointInfoId);
            request.setStreamType(dto.getStreamType() == null ? 0 : dto.getStreamType());
            request.setProtocol(StringUtil.isEmpty((String)dto.getProtocol()) ? "ws" : dto.getProtocol());
            request.setTransmode(dto.getTransmode() == null ? 0 : dto.getTransmode());
            request.setExpand(StringUtil.isEmpty((String)dto.getExpand()) ? "transcode=0" : dto.getExpand());
            try {
                String previewURLsResponse = this.hkArtemisRequest.previewURLs(request);
                JSONObject regionsJson = JSONObject.parseObject((String)previewURLsResponse);
                if ("0".equals(regionsJson.getString("code"))) {
                    JSONObject dataJson = regionsJson.getJSONObject("data");
                    String url = dataJson.getString("url");
                    if (url.contains(NW_IP)) {
                        String modifiedUrl = url.replace(NW_IP, WW_IP);
                        vo.setUrl(modifiedUrl);
                    } else {
                        vo.setUrl(url);
                    }
                    vo.setMonitorPointInfoId(monitorPointInfoId);
                    vo.setStatus(true);
                }
            }
            catch (Exception e) {
                vo.setMonitorPointInfoId(monitorPointInfoId);
                vo.setStatus(false);
                vo.setErrMessage(e.getMessage());
            }
            urlVOs.add(vo);
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", urlVOs);
    }

    @Override
    public List<BizVideoMonitorPointInfo> getMonitorPointInfosByIds(List<String> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BizVideoMonitorPointInfo::getId, ids);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<VideoMonitorPointCountDTO> getCountGroupByUnitIndexCode() {
        return ((BizVideoMonitorPointInfoDao)this.baseMapper).getCountGroupByUnitIndexCode();
    }

    public void addPosAndCarWs(List<BizVideoMonitorPointInfo> list) {
        list.removeIf(pointInfo -> {
            String name = pointInfo.getName();
            return Objects.nonNull(name) && name.contains("-\u6e1d") && (name.contains("\u8f66\u8f7d") || name.contains("\u4e91\u53f0") || name.contains("\u5e03\u63a7\u7403"));
        });
    }

    public void addPosAndCarCq(List<BizVideoMonitorPointInfo> list) {
        list.removeIf(pointInfo -> {
            String name = pointInfo.getName();
            return Objects.isNull(name) || !name.contains("-\u6e1d") || !name.contains("\u8f66\u8f7d") && !name.contains("\u4e91\u53f0") && !name.contains("\u5e03\u63a7\u7403");
        });
    }
}

