/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.monitor.utils;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.conf.NettyConfig;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageUtil.class);

    public static void sendWebSocketMessage(String topic, String operateType, JSONObject data) {
        try {
            JSONObject message = new JSONObject();
            message.put("messageType", (Object)topic);
            message.put("topic", (Object)topic);
            message.put("operate", (Object)operateType);
            message.put("timestamp", (Object)LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            try {
                message.put("userId", (Object)ContextUtil.getCurrentUserId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info("\u51c6\u5907\u53d1\u9001 WebSocket \u6d88\u606f: {}", (Object)message.toJSONString());
            NettyConfig.getChannelGroup().writeAndFlush((Object)new TextWebSocketFrame(message.toJSONString()));
            log.info("\u6d88\u606f\u53d1\u9001\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("WebSocket\u6d88\u606f\u53d1\u9001\u5931\u8d25, Topic: {}", (Object)topic, (Object)e);
        }
    }
}

