/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import com.alibaba.fastjson.JSON;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.rescue.event.dao.BizRescueUploadDao;
import com.artfess.rescue.event.manager.BizRescueHandleManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.manager.BizRescueUploadManager;
import com.artfess.rescue.event.model.BizRescueHandle;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.event.model.BizRescueUpload;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizRescueUploadManagerImpl
extends BaseManagerImpl<BizRescueUploadDao, BizRescueUpload>
implements BizRescueUploadManager {
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    BizRescueInfoManager rescueInfoManager;
    @Resource
    BizRescueHandleManager handleManager;

    @Override
    @Transactional
    public boolean isAffirm(String id) throws InvocationTargetException, IllegalAccessException {
        BizRescueUpload rescueUpload = (BizRescueUpload)((Object)((BizRescueUploadDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)rescueUpload), (String)"\u8bf7\u6838\u5b9e\u8be5\u4e8b\u4ef6\u662f\u5426\u5b58\u5728");
        boolean update = this.updateByStatus(id, 2);
        if (!update) {
            return false;
        }
        BizRescueInfo rescueInfo = new BizRescueInfo();
        String serNumber = this.systemConfigFeignService.getNextIdByAlias("lsdjh");
        String rescueNo = JSON.parseObject((String)serNumber).get((Object)"value").toString();
        BeanUtils.copyNotNullProperties((Object)((Object)rescueInfo), (Object)((Object)rescueUpload));
        rescueInfo.setRescueStatus(-1);
        rescueInfo.setRescueNo(rescueNo);
        rescueInfo.setId(null);
        this.rescueInfoManager.save((Object)rescueInfo);
        int handleCount = this.handleManager.countNode(rescueInfo.getId(), "\u767b\u8bb0");
        if (handleCount < 1) {
            BizRescueHandle handle = this.saveUser(rescueInfo.getId(), "\u767b\u8bb0");
            this.handleManager.save((Object)handle);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateByStatus(String id, Integer status) {
        if (id == null || status == null) {
            return false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(BizRescueUpload::getId, (Object)id)).set(BizRescueUpload::getStatus, (Object)status);
        return this.update((Wrapper)updateWrapper);
    }

    BizRescueHandle saveUser(String id, String node) {
        BizRescueHandle handle = new BizRescueHandle();
        handle.setRescueId(id);
        handle.setHandleUserId(ContextUtil.getCurrentUserId());
        handle.setHandleUserName(ContextUtil.getCurrentUserName());
        handle.setHandleTeamId(ContextUtil.getCurrentOrgId());
        handle.setHandleTeamName(ContextUtil.getCurrentOrgName());
        handle.setHandleTime(LocalDateTime.now());
        handle.setRescueNode(node);
        handle.setHandleInfo(ContextUtil.getCurrentUserName() + "\u8fdb\u884c" + node);
        return handle;
    }
}

