/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.rescue.event.dao.BizRescueCostDao;
import com.artfess.rescue.event.dto.RescueCostDto;
import com.artfess.rescue.event.manager.BizRescueCostManager;
import com.artfess.rescue.event.model.BizRescueCost;
import org.springframework.stereotype.Service;

@Service
public class BizRescueCostManagerImpl
extends BaseManagerImpl<BizRescueCostDao, BizRescueCost>
implements BizRescueCostManager {
    @Override
    public JSONObject costDetails(RescueCostDto cost) {
        double trailingMileage = cost.getTrailingMileage();
        Integer nightHomeWork = cost.getNightHomeWork();
        Integer dangerousGoods = cost.getDangerousGoods();
        Integer tunnelWork = cost.getTunnelWork();
        Integer trafficAccident = cost.getTrafficAccident();
        Integer faultClass = cost.getCarType();
        JSONObject object = new JSONObject();
        object.put("trailingMileage", (Object)trailingMileage);
        object.put("nightHomeWork", (Object)nightHomeWork);
        object.put("dangerousGoods", (Object)dangerousGoods);
        object.put("tunnelWork", (Object)tunnelWork);
        object.put("trafficAccident", (Object)trafficAccident);
        object.put("faultClass", (Object)faultClass);
        if (trailingMileage < 3.0) {
            object.put("cost", (Object)(cost.getCostType() == 1 ? 500.0 : 125.0));
        } else {
            double mm = 500.0 + (trailingMileage - 3.0) * 50.0;
            object.put("cost", (Object)(cost.getCostType() == 1 ? mm : mm * 0.25));
        }
        return object;
    }
}

