/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.rescue.base.dao.BizElectronicFenecDao;
import com.artfess.rescue.base.manager.BizElectronicFenecManager;
import com.artfess.rescue.base.model.BizElectronicFenec;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.vo.RoadSegmentLevelVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizElectronicFenecManagerImpl
extends BaseManagerImpl<BizElectronicFenecDao, BizElectronicFenec>
implements BizElectronicFenecManager {
    @Resource
    RescueOrgManager orgManager;

    @Override
    public RoadSegmentLevelVO fenecTree(String type) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Set teamIdSet = this.list((Wrapper)wrapper).stream().map(BizElectronicFenec::getTeamId).collect(Collectors.toSet());
        RoadSegmentLevelVO vo = this.orgManager.teamTree(type);
        vo.getChildren().forEach(infoVO -> infoVO.getTeamList().forEach(team -> team.setIsDraw(teamIdSet.contains(team.getId()) ? "1" : "0")));
        return vo;
    }

    @Override
    public List<BizElectronicFenec> getFenec(String teamIds) {
        List<String> teamIdList = Arrays.asList(teamIds.split(","));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BeanUtils.isNotEmpty((Object)teamIds), BizElectronicFenec::getTeamId, teamIdList);
        return this.list((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public boolean deleteByTeam(String teamIds) {
        List<String> teamList = Arrays.asList(teamIds.split(","));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizElectronicFenec::getTeamId, teamList);
        return this.remove((Wrapper)wrapper);
    }
}

