/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.rescue.base.dao.BizBaseTeamDao;
import com.artfess.rescue.base.manager.BizBaseTeamCarManager;
import com.artfess.rescue.base.manager.BizBaseTeamManager;
import com.artfess.rescue.base.manager.BizBaseTeamMemberManager;
import com.artfess.rescue.base.model.BizBaseTeam;
import com.artfess.rescue.base.model.BizBaseTeamCar;
import com.artfess.rescue.base.model.BizBaseTeamMember;
import com.artfess.rescue.base.vo.TeamInfoVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizBaseTeamManagerImpl
extends BaseManagerImpl<BizBaseTeamDao, BizBaseTeam>
implements BizBaseTeamManager {
    @Resource
    BizBaseTeamCarManager teamCarManager;
    @Resource
    BizBaseTeamMemberManager teamMemberManager;

    @Override
    public PageList<BizBaseTeam> findByPage(QueryFilter<BizBaseTeam> queryFilter) {
        queryFilter.addFilter("t.is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("r.is_dele_", (Object)"0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizBaseTeam> page = ((BizBaseTeamDao)this.baseMapper).findByPage((IPage<BizBaseTeam>)this.convert2IPage(pageBean), (Wrapper<BizBaseTeam>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(page);
    }

    @Override
    public BizBaseTeam findById(String id) {
        BizBaseTeam entity = ((BizBaseTeamDao)this.baseMapper).findById(id);
        if (entity == null) {
            return new BizBaseTeam();
        }
        List<BizBaseTeamCar> teamCars = this.teamCarManager.findByTeamId(id);
        if (teamCars != null) {
            entity.setTeamCars(teamCars);
        }
        return entity;
    }

    @Override
    @Transactional
    public boolean saveInfo(BizBaseTeam t) {
        boolean save = this.save((Object)t);
        if (!save) {
            return false;
        }
        List<BizBaseTeamCar> teamCars = t.getTeamCars();
        if (teamCars != null && !teamCars.isEmpty()) {
            for (BizBaseTeamCar teamCar : teamCars) {
                teamCar.setTeamId(t.getId());
            }
            return this.teamCarManager.saveBatch(teamCars);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateInfo(BizBaseTeam t) {
        boolean update = this.updateById((Object)t);
        if (!update) {
            return false;
        }
        List<BizBaseTeamCar> teamCars = t.getTeamCars();
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"team_id_", (Object)t.getId());
        if (teamCars != null && !teamCars.isEmpty()) {
            List teamCarIds = teamCars.stream().filter(tc -> tc.getId() != null).map(BizBaseTeamCar::getId).collect(Collectors.toList());
            wrapper.notIn((Object)"id_", teamCarIds);
            this.teamCarManager.remove((Wrapper)wrapper);
            for (BizBaseTeamCar teamCar : teamCars) {
                teamCar.setTeamId(t.getId());
            }
            return this.teamCarManager.saveOrUpdateBatch(teamCars);
        }
        this.teamCarManager.remove((Wrapper)wrapper);
        return true;
    }

    @Override
    public TeamInfoVO findTeamInfoById(String id) {
        List<BizBaseTeamMember> members;
        TeamInfoVO vo = new TeamInfoVO();
        BizBaseTeam entity = ((BizBaseTeamDao)this.baseMapper).findById(id);
        if (entity == null) {
            return vo;
        }
        vo.setId(id);
        vo.setName(entity.getName());
        vo.setType(entity.getType());
        vo.setCode(entity.getCode());
        vo.setMan(entity.getMan());
        vo.setTel(entity.getTel());
        List<BizBaseTeamCar> teamCars = this.teamCarManager.findByTeamId(id);
        if (teamCars != null) {
            vo.setCars(teamCars);
        }
        if ((members = this.teamMemberManager.getMemberById(id)) != null && !members.isEmpty()) {
            vo.setMembers(members);
        }
        return vo;
    }

    @Override
    public String getOrgByRoad(String id) {
        return ((BizBaseTeamDao)this.baseMapper).getRoadById(id);
    }

    @Override
    public String getOutById(String id, String type) {
        return ((BizBaseTeamDao)this.baseMapper).getOutById(id, type);
    }

    @Override
    public String getOrgByRoadId(String roadId) {
        return ((BizBaseTeamDao)this.baseMapper).getOrgByRoadId(roadId);
    }
}

