import req from '@/request'

const portal = window.context.portal

const headersUrlencoded = {
    'Content-type': 'application/x-www-form-urlencoded'
}

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizVideoInspection/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function taskDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizVideoInspection/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function taskSave(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizVideoInspection/v1/batch/save`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function taskUpdate(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizVideoInspection/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}


// 表格删除
export function taskDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizVideoInspection/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function downloadModel() {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/bizVideoInspection/v1/downModel`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
