import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventProgress/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizEventProgress/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventProgress/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizEventProgress/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 导出
export function exportList(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventProgress/v1/wordExport`, data, 'blob')
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/event/bizEventProgress/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
