import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionResultDetail/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/patrol/bizInspectionResultDetail/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionResultDetail/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/patrol/bizInspectionResultDetail/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 预览
export function filePreview(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/ledger`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function exportDataFileUser(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/ledger/excelExport`, data, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}


//查询应打卡点位信息
export function checkInPointInformation(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTaskDetails/v1/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

//查询未打卡点位信息
export function uncheckedPointInformation(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTaskDetails/v1/query/unFinish`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}