import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizCompensationInfo/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizCompensationInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizCompensationInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizCompensationInfo/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 批量删除
export function bulkDeletion(ids) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizCompensationInfo/v1/delete?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/event/bizCompensationInfo/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 赔偿清单删除
export function listDeletion(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizCompensationDetails/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportExcel(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizCompensationInfo/v1/export`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 路段列表
export function roadData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseRoad/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

