import req from '@/request'

const portal = window.context.portal

// 表格分页/bizBaseCar/v1/query/bizBaseCar/v1/query
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseCar/v1/findByPage`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增车列表查询
export function carList(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseCar/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseTeamCar/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 车牌号去重校验
export function verifyCarNumber({carNumber, id}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseCar/v1/isVerSuccessfulCarNumber?carNumber=${carNumber}&id=${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizBaseTeamCar/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 车牌号去重验证
export function carNumberDeWeight(data) {
  const {id, carNumber} = data
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseCar/v1/isVerSuccessfulCarNumber?id=${id}&carNumber=${carNumber}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseCar/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizBaseCar/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 附件删除
export function deleteFileById(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/file/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/countTeamTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
