import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/kh/scheme/plan/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/kh/scheme/plan/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/kh/scheme/plan/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/kh/scheme/plan/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/kh/scheme/plan/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 废弃
export function discard(ids) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/kh/scheme/plan/discard?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 执行/恢复计划
export function executePlan(ids) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/kh/scheme/plan/executePlan?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 暂停计划
export function pausePlan(ids) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/kh/scheme/plan/pausePlan?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 结束计划
export function endPlanInter(ids) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/kh/scheme/plan/endPlan?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
