import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizMaterials/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizMaterials/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function tableAdd(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizMaterials/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function tableEdit(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizMaterials/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function tableDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizMaterials/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 总流水台账
export function tableRecord(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizMaterials/v1/getOverall/record', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 导出总流水台账
export function exportData(data) {
    return new Promise((resolve, reject) => {
        req.downloadPostCopy(portal + '/bizMaterials/v1/getOverall/record/export', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 物资出入库明细台账
export function InOutRecord(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + "/bizMaterials/v1/getRecords", data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 导出物资出入库明细台账
export function exportInOutData(data) {
    return new Promise((resolve, reject) => {
        req.downloadPostCopy(portal + '/bizMaterials/v1/getRecords/export', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}