import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBudgetPayDetail/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizBudgetPayDetail/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function tableAdd(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBudgetPayDetail/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function tableDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizBudgetPayDetail/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 下载导入模板
export function downloadModel() {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/bizBudgetPayDetail/v1/downloadModel`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 导出预算明细
export function exportDetailData(budgetId) {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/bizBudgetPayDetail/v1/export/` + budgetId)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}



// 表格修改
export function tableEdit(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizBudgetPayDetail/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}