import req from '@/request'

const portal = window.context.portal

// 表格分页
export default {
    budgetData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/budget`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    reportData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/reports/hazard`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    materialsTypeData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/materials/type`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    materialsDetailData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/materials/detail`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    inInventoryData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/materials/inventory`, data)
                .then(res => resolve(res?.data || []))
                .catch(err => reject(err))
        })
    },
    outInventoryData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/materials/outbound`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    publishTaskData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/exam/task`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    newcomerTaskData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/exam/newEmployees`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    emergencyDrill(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/reports/emergencyDrill`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    claims(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/insurance/claims`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },
    equipment(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/open/v1/fire/equipment`, data)
                .then(res => resolve(res?.data || {}))
                .catch(err => reject(err))
        })
    },

}
