import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/patrol/bizInspectionTask/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/patrol/bizInspectionTask/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

//批量发布
export function tablePublish(list) {
  const queryString = 'ids=' + list.map(id => id).join('&ids=')
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionPlan/v1/executeJob/list?${queryString}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 异常表格分页
export function tableYiChaData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/complete/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function exportDataFile(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/ledger/export`, data, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}