import req from '@/request'

const portal = window.context.portal

// 表格分页
export function getTableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizInspectRankInfo/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizInspectRankInfo/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizInspectRankInfo/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizInspectRankInfo/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除 (使用 FormData 传参)
export function tableDelete(data) {

  return new Promise((resolve, reject) => {
    // 设置请求头为 multipart/form-data
    const config = {
      headers: {
        'Content-Type': 'multipart/form-data'
      }
    }
    req.post(portal + `/bizInspectRankInfo/v1/removes`, data, config)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获得单位树
export function orgTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/teamTree`)
      .then(res => resolve(res.data || []))
      .catch(err => reject(err))
  })
}
