import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 事件新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizRescueInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 委派
export function appoint(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/appoint`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 撤回
export function revocation(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/cancel?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizRescueInfo/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/event/bizRescueInfo/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增处置环节
export function addEventStep(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueHandle/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 救援详情处置环节
export function incidentHandling(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueHandle/v1/accept`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取环节列表
export function getDictionaryDetail(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/sys/sysDictionary/v1/getDictionaryDetail?code=${data.code}&value=${data.value}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}