import req from '@/request'

const portal = window.context.portal

// 获取组织架构
export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 当前任务
export function tableDataa(list) {
  const queryString = 'orgList=' + list.map(id => id).join('&orgList=')
  return new Promise((resolve, reject) => {
    req.get(portal + `/workbench/v1/pushTaskNum?${queryString}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

//任务列表
export function tableDataaList(data, type) {
  // const queryString = 'orgList=' + list.map(id => id).join('&orgList=') + `&type=${type}`
  return new Promise((resolve, reject) => {
    req.post(portal + `/workbench/v1/pushTaskNumList?type=${type}`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

//异常信息
export function tableDatab(list) {
  const queryString = 'orgList=' + list.map(id => id).join('&orgList=')
  return new Promise((resolve, reject) => {
    req.get(portal + `/workbench/v1/issuePatrol?${queryString}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

//异常列表
export function tableDatacList(data) {
  // const queryString = 'orgList=' + list.map(id => id).join('&orgList=')
  return new Promise((resolve, reject) => {
    req.post(portal + `/workbench/v1/issuePatrolList`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

//事件查询
export function tableDatac(data, list, startTime, endTime) {
  const queryString = 'orgList=' + list.map(id => id).join('&orgList=') + `&startTime=${startTime}&endTime=${endTime}`
  return new Promise((resolve, reject) => {
    req.get(portal + `/workbench/v1/eventNum?${queryString}`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

//事件列表
export function tableDatabList(data) {
  // const queryString = 'orgList=' + list.map(id => id).join('&orgList=')
  return new Promise((resolve, reject) => {
    req.post(portal + `/workbench/v1/eventList`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}









