import req from '@/request'

const portal = window.context.portal

// 表格分页
export function reportData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizReports/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function getReportDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizReports/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function reportAdd(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizReports/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function reportEdit(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizReports/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function reportDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizReports/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 发布/取消报表 toggle切换式接口
export function publishReport(id) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReports/v1/issue/' + id)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 填报报表
export function fillReportData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReports/v1/getTodoReports', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 待报表填报
export function todoReportData() {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReports/v1/todo')
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 报表授权保存
export function reportAuth(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReportsAuthority/v1/batchSave', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 报表授权查询
export function getReportAuth(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReportsAuthority/v1/query', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}