import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBudget/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizBudget/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function tableAdd(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBudget/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function tableDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizBudget/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function tableEdit(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizBudget/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 批量保存预算明细
export function detailSave(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBudgetDetail/v1/save`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 预算明细分页查询
export function detailDataQuery(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBudgetDetail/v1/query`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 预算明细删除
export function detailDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizBudgetDetail/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 下载导入模板
export function downloadModel() {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/bizBudgetDetail/v1/downModel`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 导出预算明细
export function exportDetailData(budgetId) {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/bizBudgetDetail/v1/export/` + budgetId)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

