import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseTunnel/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 同步数据
export function synchroData() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseTunnel/v1/SynchronizeData`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseTunnel/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
