import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizMaterialsTransactions/v1/page`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizMaterialsTransactions/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function tableAdd(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizMaterialsTransactions/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function tableEdit(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizMaterialsTransactions/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function tableDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizMaterialsTransactions/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格批量保存
export function recordSave(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizMaterialsTransactions/v1/batch/save`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 下载明细导入模板文件
export function downloadModel() {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/bizMaterialsTransactions/v1/downModel`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

