import req from '@/request'

const portal = window.context.portal

// 获取目录
export function getTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/freshman/subject/getTree`)
      .then(res => resolve(res.data?.value || []))
      .catch(err => reject(err))
  })
}

// 目录详情
export function treeDetails(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/exam/freshman/subject/${id}`)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录新增
export function treeAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/freshman/subject/`, data)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录修改
export function treeEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/exam/freshman/subject/`, data)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录删除
export function treeDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/exam/freshman/subject/?ids=${ids}`)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/subject/data/query`, data)
      .then(res => {
        resolve(res?.data || {})
      })
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/exam/subject/data/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/subject/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/exam/subject/data/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/exam/subject/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}


