/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.welfare.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.welfare.dao.AssetPubilcInfoDao;
import com.artfess.ljzc.welfare.manager.AssetPubilcInfoManager;
import com.artfess.ljzc.welfare.manager.AssetPublicUseManager;
import com.artfess.ljzc.welfare.manager.AssetPublicWarrentsManager;
import com.artfess.ljzc.welfare.model.AssetPubilcInfo;
import com.artfess.ljzc.welfare.model.AssetPublicUse;
import com.artfess.ljzc.welfare.model.AssetPublicWarrents;
import com.artfess.ljzc.welfare.vo.AssetPubilcInfoVo;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AssetPubilcInfoManagerImpl
extends BaseManagerImpl<AssetPubilcInfoDao, AssetPubilcInfo>
implements AssetPubilcInfoManager {
    @Autowired
    AssetPublicUseManager publicUseManager;
    @Autowired
    AssetPublicWarrentsManager publicWarrentsManager;

    @Override
    public PageList<AssetPubilcInfoVo> queryPubilcInfoVoPage(QueryFilter<AssetPubilcInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<AssetPubilcInfoVo> result = ((AssetPubilcInfoDao)this.baseMapper).queryPubilcInfoVoPage((IPage<AssetPubilcInfo>)this.convert2IPage(pageBean), (QueryWrapper<AssetPubilcInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String insertPubilcInfo(AssetPubilcInfo pubilcInfo) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)pubilcInfo))) {
            if (StringUtil.isEmpty((String)pubilcInfo.getAssetAudit())) {
                pubilcInfo.setAssetAudit("0");
            }
            if (StringUtil.isEmpty((String)pubilcInfo.getBelongsOrgId())) {
                pubilcInfo.setBelongsOrgId(ContextUtil.getCurrentOrgId());
                pubilcInfo.setBelongsOrgName(ContextUtil.getCurrentOrgName());
                pubilcInfo.setBelongsOrgFullId(ContextUtil.getCurrentOrgFullId());
            }
            ((AssetPubilcInfoDao)this.baseMapper).insert((Object)pubilcInfo);
            List<AssetPublicUse> uselist = pubilcInfo.getAssetPublicUse();
            List<AssetPublicWarrents> warrentslist = pubilcInfo.getAssetPublicWarrents();
            if (!CollectionUtils.isEmpty(uselist)) {
                uselist.forEach(s -> s.setPublicId(pubilcInfo.getId()));
                this.publicUseManager.saveBatch(uselist);
            }
            if (!CollectionUtils.isEmpty(warrentslist)) {
                warrentslist.forEach(s -> s.setPublicId(pubilcInfo.getId()));
                this.publicWarrentsManager.saveBatch(warrentslist);
            }
            return pubilcInfo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updatePubilcInfo(AssetPubilcInfo pubilcInfo) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)pubilcInfo))) {
            this.saveOrUpdate((Object)pubilcInfo);
            List<AssetPublicUse> uselist = pubilcInfo.getAssetPublicUse();
            List<AssetPublicWarrents> warrentslist = pubilcInfo.getAssetPublicWarrents();
            QueryWrapper delUseWrapper = new QueryWrapper();
            delUseWrapper.eq((Object)"public_id_", (Object)pubilcInfo.getId());
            this.publicUseManager.getBaseMapper().delete((Wrapper)delUseWrapper);
            QueryWrapper delWarrentsWrapper = new QueryWrapper();
            delWarrentsWrapper.eq((Object)"public_id_", (Object)pubilcInfo.getId());
            this.publicWarrentsManager.getBaseMapper().delete((Wrapper)delWarrentsWrapper);
            if (!CollectionUtils.isEmpty(uselist)) {
                uselist.forEach(s -> s.setPublicId(pubilcInfo.getId()));
                this.publicUseManager.saveOrUpdateBatch(uselist);
            }
            if (!CollectionUtils.isEmpty(warrentslist)) {
                warrentslist.forEach(s -> s.setPublicId(pubilcInfo.getId()));
                this.publicWarrentsManager.saveOrUpdateBatch(warrentslist);
            }
            return true;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deletePubilcInfo(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8d44\u4ea7\uff01");
        boolean flag = this.removeById((Serializable)((Object)id));
        if (flag) {
            QueryWrapper delUseWrapper = new QueryWrapper();
            delUseWrapper.eq((Object)"public_id_", (Object)id);
            this.publicUseManager.getBaseMapper().delete((Wrapper)delUseWrapper);
            QueryWrapper delWarrentsWrapper = new QueryWrapper();
            delWarrentsWrapper.eq((Object)"public_id_", (Object)id);
            this.publicWarrentsManager.getBaseMapper().delete((Wrapper)delWarrentsWrapper);
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteBachPubilcInfo(List<String> ids) {
        Assert.noNullElements(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8d44\u4ea7\uff01");
        boolean flag = this.removeByIds(ids);
        if (flag) {
            QueryWrapper delUseWrapper = new QueryWrapper();
            delUseWrapper.in((Object)"public_id_", ids);
            this.publicUseManager.getBaseMapper().delete((Wrapper)delUseWrapper);
            QueryWrapper delWarrentsWrapper = new QueryWrapper();
            delWarrentsWrapper.in((Object)"public_id_", ids);
            this.publicWarrentsManager.getBaseMapper().delete((Wrapper)delWarrentsWrapper);
        }
        return flag;
    }

    @Override
    public AssetPubilcInfo findPubilcInfo(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u8be2\u7684\u8d44\u4ea7\uff01");
        AssetPubilcInfo assetPubilcInfo = (AssetPubilcInfo)((Object)this.getById((Serializable)((Object)id)));
        if (BeanUtils.isNotEmpty((Object)((Object)assetPubilcInfo))) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"public_id_", (Object)id);
            queryWrapper.orderByDesc((Object)"fill_year_");
            List list = this.publicUseManager.list((Wrapper)queryWrapper);
            assetPubilcInfo.setAssetPublicUse(list);
            QueryWrapper queryWarrentsWrapper = new QueryWrapper();
            queryWarrentsWrapper.eq((Object)"public_id_", (Object)id);
            List warrentsList = this.publicWarrentsManager.list((Wrapper)queryWarrentsWrapper);
            assetPubilcInfo.setAssetPublicWarrents(warrentsList);
            return assetPubilcInfo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean auditLoan(String status, String msg, List<String> idList) {
        Assert.hasText((String)status, (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(idList, (String)"\u8bf7\u9009\u62e9\u8981\u5ba1\u6838\u7684\u8d44\u4ea7");
        Integer result = null;
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"asset_audit_", (Object)status);
        updateWrapper.set((Object)"audit_msg_", (Object)msg);
        updateWrapper.in((Object)"id_", idList);
        result = ((AssetPubilcInfoDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        return null != result && result >= 1;
    }

    @Override
    public JSONObject publicStatistics(String fullId) {
        return ((AssetPubilcInfoDao)this.baseMapper).publicStatistics(fullId);
    }
}

