/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.job;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.ApplicationFeignService;
import com.artfess.base.feign.dto.MsgTemplateDto;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.Notice;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.uc.api.service.IUserService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TestJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(TestJob.class);

    public void executeJob(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String id = jobDataMap.getString("id");
        String logId = (String)jobDataMap.get((Object)"logId");
        String msgId = jobDataMap.getString("msgId");
        log.info("\u5b9a\u65f6\u8ba1\u5212\u6d4b\u8bd5\u6b63\u5e38com.artfess.application.job.TestJob\uff0cmsgId:{}\uff0cid:{}\uff0clogId:{}", new Object[]{msgId, id, logId});
        if (StringUtil.isEmpty((String)msgId)) {
            log.error("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\u5b9a\u65f6\u5668\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u77ed\u4fe1\u6a21\u677fid\u4e3a\u7a7a\uff01", (Object)((Object)((Object)this)).getClass().getName());
            throw new BaseException("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u77ed\u4fe1\u6a21\u677fid\u4e3a\u7a7a");
        }
        ApplicationFeignService applicationFeignService = (ApplicationFeignService)AppUtil.getBean(ApplicationFeignService.class);
        MsgTemplateDto msgTemplate = applicationFeignService.getMsgTemplate(msgId);
        if (null == msgTemplate) {
            throw new BaseException("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u77ed\u4fe1\u6a21\u677f\u672a\u627e\u5230\uff0c\u6d88\u606f\u6a21\u677fID\uff1a" + msgId);
        }
        this.processMsg(msgTemplate);
    }

    private void processMsg(MsgTemplateDto msgTemplate) {
        String key = msgTemplate.getKey();
        ApplicationFeignService applicationFeignService = (ApplicationFeignService)AppUtil.getBean(ApplicationFeignService.class);
        List list = applicationFeignService.getMessageConfigList(key);
        HashMap vars = Maps.newHashMap();
        vars.put("name", "2023\u5e741\u6708\u6392\u67e5\u65b9\u6848");
        list.forEach(messageConfig -> {
            String userIds = messageConfig.getUserId();
            String orgIds = messageConfig.getOrgId();
            ArrayList reciever = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)userIds) || StringUtils.isNotBlank((CharSequence)orgIds)) {
                reciever.addAll(this.getUserList(userIds, orgIds));
            }
            this.sendMsg(msgTemplate, reciever, messageConfig.getNotifyType(), vars);
        });
    }

    private void sendMsg(MsgTemplateDto msgTemplate, List<JmsActor> reciever, String notifyType, Map<String, Object> vars) {
        NoticeMessageType[] messageTypes;
        for (NoticeMessageType type : messageTypes = NoticeMessageType.parseNotifyType((String)notifyType)) {
            Notice notice = new Notice();
            notice.setSubject(msgTemplate.getSubject());
            notice.setReceiver(reciever);
            notice.setUseTemplate(true);
            notice.setMessageTypes(new NoticeMessageType[]{type});
            notice.setTemplateType(msgTemplate.getTypeKey());
            notice.setTemplateKey(msgTemplate.getKey());
            notice.setVars(vars);
            if (type.isPlain().booleanValue()) {
                notice.setContent(msgTemplate.getPlain());
            } else {
                notice.setContent(msgTemplate.getHtml());
            }
            ApplicationFeignService applicationFeignService = (ApplicationFeignService)AppUtil.getBean(ApplicationFeignService.class);
            applicationFeignService.sendNoticeToQueue(notice);
        }
    }

    public List<JmsActor> getUserList(String userIds, String orgIds) {
        List listByOrg;
        ArrayList userList = new ArrayList();
        IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
        List listByUser = userService.getUserByIds(userIds);
        if (!CollectionUtils.isEmpty((Collection)listByUser)) {
            userList.addAll(listByUser);
        }
        if (!StringUtil.isEmpty((String)orgIds) && !CollectionUtils.isEmpty((Collection)(listByOrg = userService.getUserListByGroups("org", orgIds)))) {
            userList.addAll(listByOrg);
        }
        List reciever = JmsActor.parseJmsActor(userList);
        return reciever;
    }
}

