var vows = require('vows');
var assert = require('assert');
var suite = vows.describe('jStat');

require('../env.js');

suite.addBatch({
  'model test': {
    'topic': function() {
      return jStat;
    },
    'array call': function(jStat) {
	  // The result is reviewed by R.
	  var exog = [[1, 0.9],
				  [1, 2.1],
				  [1, 2.9],
				  [1, 4.1],
				  [1, 4.9],
				  [1, 6.1],
				  [1, 6.9],
				  [1, 8.1],
				  [1, 8.9],
				  [1, 10.1]];
      var endog = [11, 12, 13, 14, 15, 16, 17, 18, 19, 20];
      //var exog  = [[-2.302585093,7.0,36.0,3.0,1.0,1],[5.2475502495,3.0,20.0,4.0,1.0,1],[3.4372078192,2.0,24.0,6.0,1.0,1],[4.4200447019,3.0,28.0,6.0,1.0,1],[6.4616244141,5.0,68.0,6.0,1.0,1],[4.7013890437,3.0,21.0,4.0,1.0,1],[4.6061696863,5.0,77.0,4.0,1.0,1],[3.4372078192,5.0,21.0,4.0,1.0,1],[5.1935122522,4.0,31.0,4.0,1.0,1],[7.9374104098,3.0,39.0,3.0,1.0,1],[7.3778214063,3.0,26.0,2.0,1.0,1],[5.7993956389,4.0,31.0,4.0,1.0,1],[5.2475502495,5.0,22.0,4.0,1.0,1],[4.6061696863,4.0,42.0,5.0,1.0,1],[6.907855274,5.0,74.0,1.0,1.0,1],[-2.302585093,6.0,62.0,3.0,1.0,1],[4.8683033855,4.0,58.0,3.0,1.0,1],[1.6292405397,3.0,24.0,6.0,1.0,1],[3.4995332824,6.0,51.0,4.0,1.0,1],[2.9496883351,2.0,36.0,3.0,2.0,1],[4.3054155323,4.0,88.0,2.0,2.0,1],[5.2475502495,2.0,20.0,4.0,2.0,1],[2.4932054526,4.0,27.0,3.0,2.0,1],[-2.302585093,6.0,44.0,4.0,2.0,1],[2.9496883351,4.0,45.0,3.0,2.0,1],[-2.302585093,4.0,21.0,4.0,2.0,1],[5.9664031165,3.0,40.0,5.0,2.0,1],[3.6913763343,4.0,40.0,6.0,2.0,1],[1.1314021115,5.0,48.0,3.0,2.0,1],[6.1094697803,4.0,34.0,3.0,2.0,1],[5.858218828,3.0,26.0,2.0,2.0,1],[4.1604443639,4.0,60.0,2.0,3.0,1],[1.1314021115,4.0,32.0,3.0,3.0,1],[-2.302585093,4.0,31.0,3.0,3.0,1],[6.4616244141,7.0,33.0,3.0,3.0,1],[-2.302585093,3.0,57.0,3.0,3.0,1],[2.4932054526,4.0,84.0,3.0,3.0,1],[4.1287459889,7.0,75.0,3.0,3.0,1],[3.4372078192,7.0,19.0,4.0,3.0,1],[-2.302585093,3.0,47.0,6.0,3.0,1],[5.1935122522,5.0,51.0,2.0,3.0,1],[6.4616244141,6.0,40.0,3.0,3.0,1],[4.7013890437,2.0,22.0,6.0,3.0,1],[4.6061696863,7.0,35.0,2.0,3.0,1],[4.6061696863,4.0,43.0,5.0,3.0,1],[2.4069451083,6.0,76.0,6.0,3.0,1],[-2.302585093,4.0,45.0,3.0,3.0,1],[1.4109869737,4.0,88.0,2.0,3.0,1],[3.5582011305,4.0,46.0,3.0,4.0,1],[-2.302585093,3.0,22.0,6.0,4.0,1],[-2.302585093,5.0,68.0,3.0,4.0,1],[-2.302585093,5.0,38.0,3.0,4.0,1],[3.4995332824,4.0,69.0,2.0,4.0,1],[5.5987922608,5.0,67.0,3.0,4.0,1],[3.8088822465,2.0,88.0,4.0,4.0,1],[3.6913763343,6.0,68.0,3.0,4.0,1],[1.8082887712,5.0,76.0,3.0,4.0,1],[0.7419373447,4.0,72.0,2.0,4.0,1],[-2.302585093,6.0,37.0,6.0,4.0,1],[3.5582011305,4.0,69.0,3.0,4.0,1],[4.4200447019,2.0,33.0,6.0,4.0,1],[8.1605468185,2.0,34.0,4.0,4.0,1],[4.6061696863,4.0,30.0,3.0,4.0,1],[5.858218828,3.0,19.0,3.0,4.0,1],[4.6061696863,4.0,44.0,3.0,4.0,1],[4.206184044,4.0,64.0,3.0,4.0,1],[3.4045251718,7.0,37.0,4.0,4.0,1],[-2.302585093,6.0,31.0,5.0,5.0,1],[-2.302585093,6.0,88.0,4.0,5.0,1],[1.8082887712,6.0,77.0,4.0,5.0,1],[5.858218828,4.0,30.0,6.0,5.0,1],[5.9917145159,2.0,32.0,4.0,5.0,1],[2.7146947438,6.0,59.0,1.0,5.0,1],[-2.302585093,4.0,47.0,4.0,5.0,1],[1.1314021115,4.0,22.0,3.0,5.0,1],[3.0955776085,4.0,55.0,3.0,5.0,1],[4.1604443639,2.0,24.0,2.0,5.0,1],[3.4688560301,3.0,65.0,1.0,5.0,1],[5.9664031165,3.0,24.0,3.0,5.0,1],[-2.302585093,3.0,30.0,3.0,5.0,1],[-2.302585093,4.0,73.0,3.0,5.0,1],[4.0792309244,3.0,73.0,5.0,5.0,1],[-2.302585093,4.0,91.0,1.0,5.0,1],[3.5582011305,3.0,71.0,2.0,5.0,1],[-2.302585093,6.0,34.0,4.0,5.0,1],[5.1363864994,4.0,48.0,2.0,6.0,1],[2.4932054526,6.0,42.0,4.0,6.0,1],[3.6913763343,6.0,72.0,2.0,6.0,1],[3.4372078192,3.0,20.0,4.0,6.0,1],[3.4372078192,2.0,22.0,4.0,6.0,1],[7.3778214063,3.0,24.0,6.0,6.0,1],[0.0953101798,4.0,39.0,6.0,6.0,1],[1.4109869737,6.0,83.0,5.0,6.0,1],[5.2475502495,6.0,39.0,3.0,6.0,1],[3.9721769282,5.0,33.0,5.0,6.0,1],[3.4372078192,4.0,53.0,3.0,6.0,1],[2.778819272,5.0,82.0,3.0,6.0,1],[3.4995332824,4.0,82.0,3.0,6.0,1],[-2.302585093,5.0,47.0,6.0,7.0,1],[-2.302585093,4.0,68.0,3.0,7.0,1],[-2.302585093,4.0,84.0,6.0,7.0,1],[3.2995337279,6.0,35.0,5.0,7.0,1],[4.432006567,4.0,67.0,2.0,7.0,1],[3.0955776085,5.0,33.0,2.0,7.0,1],[-2.302585093,3.0,49.0,7.0,7.0,1],[8.1605468185,4.0,91.0,1.0,7.0,1],[5.9664031165,4.0,43.0,3.0,7.0,1],[-2.302585093,4.0,65.0,4.0,7.0,1],[2.778819272,5.0,69.0,3.0,7.0,1],[5.2988172416,5.0,56.0,4.0,8.0,1],[6.4616244141,2.0,24.0,6.0,8.0,1],[-2.302585093,4.0,77.0,3.0,8.0,1],[3.8088822465,6.0,74.0,3.0,8.0,1],[2.4932054526,7.0,25.0,6.0,8.0,1],[3.0007198151,6.0,85.0,1.0,8.0,1],[8.8956433257,7.0,21.0,2.0,8.0,1],[4.1604443639,6.0,24.0,4.0,8.0,1],[2.5726122302,5.0,73.0,4.0,8.0,1],[5.2475502495,4.0,37.0,3.0,8.0,1],[2.2082744135,4.0,35.0,4.0,8.0,1],[-2.302585093,4.0,47.0,3.0,8.0,1],[5.1363864994,4.0,21.0,3.0,8.0,1],[6.4616244141,3.0,55.0,5.0,8.0,1],[2.2082744135,6.0,30.0,6.0,8.0,1],[-2.302585093,5.0,76.0,7.0,8.0,1],[8.8956433257,3.0,36.0,4.0,8.0,1],[7.9374104098,1.0,38.0,3.0,9.0,1],[-2.302585093,2.0,67.0,3.0,9.0,1],[3.4045251718,7.0,70.0,2.0,9.0,1],[3.7864597825,5.0,78.0,4.0,9.0,1],[8.8956433257,2.0,27.0,6.0,9.0,1],[5.7993956389,3.0,51.0,4.0,9.0,1],[1.1314021115,6.0,33.0,4.0,9.0,1],[3.9337844972,6.0,80.0,6.0,9.0,1],[3.3707381742,4.0,79.0,1.0,9.0,1],[6.4458785369,6.0,66.0,1.0,9.0,1],[5.1363864994,4.0,32.0,3.0,10.0,1],[3.4995332824,4.0,70.0,2.0,10.0,1],[-2.302585093,2.0,42.0,3.0,10.0,1],[2.2082744135,5.0,73.0,4.0,10.0,1],[3.0955776085,4.0,87.0,2.0,10.0,1],[4.6061696863,7.0,30.0,5.0,10.0,1],[0.7419373447,4.0,52.0,3.0,10.0,1],[-2.302585093,5.0,62.0,4.0,10.0,1],[3.9140210081,6.0,67.0,3.0,10.0,1],[2.7146947438,6.0,37.0,6.0,10.0,1],[1.1314021115,3.0,37.0,4.0,10.0,1],[6.5793900913,1.0,64.0,6.0,10.0,1],[6.4616244141,1.0,34.0,3.0,10.0,1],[1.6292405397,4.0,70.0,3.0,10.0,1],[3.1822118405,6.0,31.0,5.0,10.0,1],[3.0955776085,2.0,29.0,6.0,11.0,1],[4.0091497162,4.0,71.0,2.0,11.0,1],[-2.302585093,4.0,67.0,1.0,11.0,1],[7.3778214063,4.0,41.0,7.0,11.0,1],[5.1363864994,1.0,49.0,6.0,11.0,1],[6.907855274,4.0,42.0,5.0,11.0,1],[4.1447207695,6.0,78.0,2.0,11.0,1],[4.7013890437,4.0,24.0,3.0,11.0,1],[2.778819272,4.0,29.0,3.0,11.0,1],[4.6061696863,4.0,39.0,5.0,11.0,1],[8.8956433257,5.0,19.0,4.0,11.0,1],[3.0955776085,4.0,32.0,5.0,11.0,1],[4.2640873368,4.0,69.0,3.0,11.0,1],[6.8025058683,5.0,83.0,3.0,11.0,1],[3.5582011305,4.0,76.0,2.0,11.0,1],[0.7419373447,7.0,62.0,2.0,11.0,1],[4.4200447019,3.0,47.0,7.0,11.0,1],[5.9137732394,6.0,35.0,3.0,11.0,1],[2.4932054526,4.0,23.0,3.0,11.0,1],[5.9137732394,4.0,79.0,4.0,11.0,1],[4.6061696863,6.0,64.0,5.0,11.0,1],[6.152945438,6.0,70.0,4.0,11.0,1],[3.0955776085,6.0,87.0,5.0,11.0,1],[7.9374104098,3.0,28.0,2.0,12.0,1],[3.852273001,3.0,58.0,3.0,12.0,1],[6.8025058683,4.0,85.0,2.0,12.0,1],[5.7993956389,3.0,62.0,3.0,12.0,1],[4.432006567,3.0,26.0,6.0,12.0,1],[-2.302585093,6.0,28.0,3.0,12.0,1],[3.4995332824,6.0,88.0,2.0,12.0,1],[3.9721769282,2.0,57.0,6.0,12.0,1],[2.0918640617,2.0,78.0,3.0,12.0,1],[0.7419373447,4.0,56.0,3.0,12.0,1],[-2.302585093,4.0,46.0,5.0,12.0,1],[-2.302585093,4.0,20.0,3.0,12.0,1],[-2.302585093,5.0,24.0,4.0,12.0,1],[-2.302585093,5.0,72.0,4.0,12.0,1],[2.7146947438,2.0,51.0,4.0,12.0,1],[6.8025058683,6.0,34.0,6.0,12.0,1],[3.4045251718,4.0,21.0,4.0,12.0,1],[-2.302585093,4.0,74.0,7.0,12.0,1],[5.1363864994,4.0,48.0,1.0,12.0,1],[6.8025058683,3.0,28.0,3.0,12.0,1],[-2.302585093,7.0,38.0,2.0,12.0,1],[7.3778214063,4.0,70.0,3.0,12.0,1],[-2.302585093,4.0,72.0,2.0,12.0,1],[7.9374104098,4.0,41.0,3.0,12.0,1],[4.7013890437,3.0,50.0,7.0,12.0,1],[0.0953101798,6.0,73.0,3.0,12.0,1],[1.1314021115,5.0,79.0,6.0,12.0,1],[-2.302585093,5.0,76.0,2.0,12.0,1],[3.0955776085,5.0,62.0,5.0,12.0,1],[4.1447207695,6.0,30.0,6.0,12.0,1],[5.6702256911,6.0,35.0,4.0,12.0,1],[0.7419373447,1.0,66.0,4.0,12.0,1],[3.6913763343,2.0,35.0,4.0,12.0,1],[4.206184044,6.0,57.0,6.0,12.0,1],[-2.302585093,4.0,37.0,5.0,12.0,1],[6.152945438,5.0,61.0,3.0,13.0,1],[-2.302585093,6.0,56.0,3.0,13.0,1],[1.4109869737,3.0,53.0,3.0,13.0,1],[3.0007198151,4.0,24.0,6.0,13.0,1],[7.9374104098,4.0,74.0,3.0,13.0,1],[-2.302585093,4.0,36.0,3.0,13.0,1],[0.0953101798,6.0,30.0,5.0,13.0,1],[6.4616244141,4.0,55.0,2.0,13.0,1],[5.1363864994,3.0,35.0,6.0,13.0,1],[5.5987922608,3.0,26.0,4.0,13.0,1],[5.9664031165,3.0,25.0,4.0,13.0,1],[2.778819272,6.0,27.0,3.0,13.0,1],[2.4069451083,4.0,66.0,3.0,13.0,1],[-2.302585093,5.0,39.0,2.0,13.0,1],[5.5987922608,1.0,58.0,5.0,13.0,1],[5.1363864994,4.0,53.0,3.0,13.0,1],[6.8025058683,6.0,76.0,3.0,13.0,1],[5.5987922608,5.0,51.0,3.0,13.0,1],[-2.302585093,4.0,70.0,2.0,13.0,1],[5.858218828,6.0,68.0,4.0,13.0,1],[-2.302585093,5.0,32.0,3.0,13.0,1],[1.8082887712,5.0,55.0,3.0,13.0,1],[5.6702256911,2.0,52.0,4.0,13.0,1],[6.4458785369,6.0,73.0,2.0,13.0,1],[6.8025058683,5.0,42.0,2.0,13.0,1],[3.4372078192,4.0,23.0,5.0,13.0,1],[7.3778214063,2.0,30.0,7.0,14.0,1],[4.2640873368,2.0,68.0,4.0,14.0,1],[5.2988172416,5.0,68.0,3.0,14.0,1],[-2.302585093,6.0,68.0,6.0,14.0,1],[3.4045251718,2.0,38.0,5.0,14.0,1],[2.3125354238,4.0,74.0,3.0,14.0,1],[-2.302585093,5.0,59.0,2.0,14.0,1],[6.8025058683,5.0,73.0,2.0,14.0,1],[4.2640873368,2.0,79.0,3.0,14.0,1],[3.0955776085,7.0,28.0,4.0,14.0,1],[-2.302585093,6.0,50.0,3.0,14.0,1],[-2.302585093,6.0,36.0,4.0,14.0,1],[-2.302585093,6.0,50.0,3.0,14.0,1],[-2.302585093,6.0,61.0,3.0,14.0,1],[8.8956433257,2.0,37.0,4.0,14.0,1],[4.4200447019,3.0,29.0,6.0,14.0,1],[4.5336741843,2.0,39.0,4.0,14.0,1],[-2.302585093,4.0,83.0,6.0,14.0,1],[3.9337844972,6.0,68.0,6.0,14.0,1],[3.4372078192,6.0,25.0,4.0,14.0,1],[4.5336741843,1.0,41.0,6.0,14.0,1],[-2.302585093,3.0,67.0,3.0,14.0,1],[-2.302585093,4.0,36.0,6.0,14.0,1],[3.4372078192,6.0,66.0,4.0,14.0,1],[6.8025058683,3.0,55.0,4.0,14.0,1],[-2.302585093,3.0,42.0,5.0,14.0,1],[0.7419373447,6.0,42.0,3.0,14.0,1],[4.7013890437,4.0,36.0,3.0,14.0,1],[4.1447207695,6.0,53.0,5.0,14.0,1],[6.8025058683,3.0,36.0,5.0,14.0,1],[3.4372078192,4.0,29.0,7.0,14.0,1],[6.2346067849,4.0,31.0,3.0,14.0,1],[5.5987922608,3.0,43.0,6.0,14.0,1],[2.2082744135,3.0,33.0,6.0,14.0,1],[1.1314021115,6.0,63.0,3.0,14.0,1],[3.3707381742,5.0,25.0,5.0,14.0,1],[3.8088822465,3.0,72.0,4.0,14.0,1],[4.4200447019,3.0,40.0,4.0,14.0,1],[3.0955776085,4.0,27.0,6.0,14.0,1],[2.7146947438,5.0,26.0,4.0,15.0,1],[4.7013890437,5.0,67.0,3.0,15.0,1],[2.0918640617,4.0,21.0,3.0,15.0,1],[2.4069451083,6.0,27.0,7.0,15.0,1],[4.0271358125,6.0,78.0,6.0,15.0,1],[2.0918640617,4.0,32.0,3.0,15.0,1],[4.6061696863,4.0,68.0,4.0,15.0,1],[6.8025058683,4.0,76.0,4.0,15.0,1],[4.206184044,3.0,33.0,5.0,15.0,1],[3.5582011305,6.0,38.0,2.0,15.0,1],[3.5582011305,4.0,49.0,7.0,15.0,1],[3.0955776085,5.0,61.0,4.0,15.0,1],[4.7013890437,7.0,57.0,3.0,15.0,1],[2.4932054526,4.0,20.0,3.0,15.0,1],[8.8956433257,4.0,63.0,6.0,15.0,1],[-2.302585093,4.0,53.0,3.0,15.0,1],[2.9496883351,4.0,35.0,4.0,15.0,1],[6.152945438,4.0,39.0,3.0,15.0,1],[1.4109869737,3.0,48.0,3.0,15.0,1],[6.4616244141,6.0,62.0,3.0,15.0,1],[6.4616244141,4.0,30.0,5.0,15.0,1],[5.2988172416,7.0,26.0,6.0,15.0,1],[-2.302585093,3.0,74.0,6.0,15.0,1],[3.3707381742,3.0,37.0,5.0,15.0,1],[5.7993956389,4.0,43.0,5.0,15.0,1],[2.9496883351,5.0,68.0,3.0,15.0,1],[0.0953101798,5.0,73.0,5.0,15.0,1],[4.7013890437,6.0,60.0,7.0,15.0,1],[-2.302585093,5.0,35.0,3.0,15.0,1],[5.858218828,3.0,29.0,6.0,15.0,1],[0.7419373447,3.0,25.0,6.0,15.0,1],[-2.302585093,2.0,25.0,7.0,15.0,1],[1.960094784,2.0,70.0,6.0,15.0,1],[4.2640873368,6.0,41.0,3.0,15.0,1],[3.9721769282,4.0,37.0,6.0,15.0,1],[-2.302585093,6.0,39.0,5.0,15.0,1],[0.7419373447,3.0,35.0,4.0,15.0,1],[5.2475502495,2.0,62.0,7.0,15.0,1],[3.4372078192,3.0,30.0,7.0,15.0,1],[2.778819272,4.0,74.0,4.0,15.0,1],[3.0955776085,3.0,47.0,3.0,15.0,1],[1.1314021115,4.0,43.0,6.0,15.0,1],[-2.302585093,5.0,64.0,2.0,15.0,1],[-2.302585093,4.0,75.0,4.0,15.0,1],[4.206184044,4.0,27.0,6.0,15.0,1],[3.6913763343,4.0,21.0,3.0,15.0,1],[4.3054155323,2.0,70.0,2.0,15.0,1],[1.1314021115,5.0,67.0,3.0,15.0,1],[4.9423564533,6.0,82.0,5.0,15.0,1],[2.6461747974,2.0,40.0,6.0,15.0,1],[4.7013890437,5.0,26.0,4.0,15.0,1],[3.5582011305,4.0,29.0,6.0,15.0,1],[-2.302585093,4.0,28.0,6.0,15.0,1],[5.7368948261,6.0,65.0,3.0,15.0,1],[6.8025058683,6.0,25.0,3.0,15.0,1],[-2.302585093,3.0,65.0,2.0,15.0,1],[2.4069451083,6.0,38.0,5.0,15.0,1],[-2.302585093,4.0,72.0,7.0,15.0,1],[5.5987922608,3.0,67.0,3.0,15.0,1],[3.9337844972,3.0,74.0,3.0,15.0,1],[2.4069451083,2.0,71.0,6.0,15.0,1],[0.7419373447,4.0,47.0,3.0,15.0,1],[3.0007198151,5.0,69.0,1.0,15.0,1],[3.4372078192,3.0,29.0,6.0,15.0,1],[0.7419373447,6.0,34.0,3.0,15.0,1],[1.6292405397,4.0,43.0,4.0,15.0,1],[3.0955776085,2.0,30.0,3.0,15.0,1],[-2.302585093,5.0,76.0,2.0,15.0,1],[3.2995337279,2.0,26.0,5.0,16.0,1],[1.960094784,4.0,76.0,5.0,16.0,1],[-2.302585093,1.0,42.0,7.0,16.0,1],[-2.302585093,3.0,33.0,3.0,16.0,1],[-2.302585093,6.0,25.0,3.0,16.0,1],[7.9374104098,2.0,51.0,4.0,16.0,1],[-2.302585093,4.0,57.0,3.0,16.0,1],[3.0955776085,6.0,21.0,4.0,16.0,1],[2.2082744135,5.0,79.0,7.0,16.0,1],[-2.302585093,6.0,35.0,5.0,16.0,1],[2.2082744135,4.0,57.0,6.0,16.0,1],[-2.302585093,4.0,32.0,6.0,16.0,1],[3.6136169696,4.0,51.0,6.0,16.0,1],[3.1398326175,5.0,62.0,7.0,16.0,1],[-2.302585093,5.0,48.0,4.0,16.0,1],[-2.302585093,7.0,39.0,3.0,16.0,1],[-2.302585093,3.0,26.0,6.0,16.0,1],[3.6913763343,4.0,38.0,3.0,16.0,1],[-2.302585093,3.0,50.0,4.0,16.0,1],[2.2082744135,5.0,33.0,3.0,16.0,1],[2.7146947438,4.0,36.0,3.0,16.0,1],[6.4616244141,4.0,24.0,6.0,16.0,1],[-2.302585093,3.0,25.0,5.0,16.0,1],[-2.302585093,6.0,62.0,3.0,16.0,1],[-2.302585093,4.0,33.0,3.0,16.0,1],[-2.302585093,6.0,53.0,6.0,16.0,1],[3.0955776085,6.0,68.0,6.0,16.0,1],[3.0955776085,5.0,68.0,3.0,16.0,1],[2.3125354238,6.0,38.0,3.0,16.0,1],[3.3707381742,4.0,58.0,1.0,16.0,1],[5.1363864994,4.0,34.0,6.0,16.0,1],[1.4109869737,4.0,58.0,2.0,16.0,1],[2.4069451083,3.0,35.0,5.0,16.0,1],[3.4372078192,7.0,42.0,6.0,16.0,1],[-2.302585093,4.0,54.0,3.0,16.0,1],[-2.302585093,6.0,69.0,3.0,16.0,1],[5.8863817707,4.0,35.0,4.0,16.0,1],[-2.302585093,6.0,66.0,4.0,16.0,1],[6.8025058683,3.0,58.0,3.0,16.0,1],[3.9337844972,2.0,41.0,3.0,16.0,1],[-2.302585093,5.0,35.0,6.0,16.0,1],[4.7013890437,3.0,40.0,7.0,16.0,1],[0.0953101798,4.0,53.0,1.0,16.0,1],[2.0918640617,6.0,67.0,6.0,16.0,1],[1.6292405397,4.0,32.0,5.0,16.0,1],[4.4670568839,3.0,41.0,4.0,16.0,1],[1.1314021115,2.0,43.0,7.0,16.0,1],[3.9337844972,5.0,65.0,2.0,16.0,1],[5.858218828,3.0,60.0,5.0,16.0,1],[1.1314021115,5.0,77.0,6.0,16.0,1],[6.4458785369,6.0,35.0,4.0,16.0,1],[5.1935122522,6.0,48.0,4.0,16.0,1],[-2.302585093,6.0,52.0,3.0,16.0,1],[3.5582011305,5.0,43.0,7.0,16.0,1],[-2.302585093,6.0,43.0,5.0,16.0,1],[-2.302585093,6.0,67.0,4.0,16.0,1],[1.8082887712,4.0,56.0,3.0,16.0,1],[8.8956433257,3.0,62.0,4.0,16.0,1],[0.7419373447,7.0,62.0,3.0,16.0,1],[3.5582011305,3.0,22.0,6.0,16.0,1],[-2.302585093,2.0,21.0,5.0,16.0,1],[3.8088822465,6.0,34.0,3.0,16.0,1],[-2.302585093,4.0,70.0,3.0,16.0,1],[1.6292405397,3.0,50.0,3.0,16.0,1],[3.5582011305,6.0,42.0,4.0,16.0,1],[6.8025058683,6.0,73.0,3.0,16.0,1],[3.5582011305,3.0,57.0,7.0,16.0,1],[-2.302585093,6.0,40.0,6.0,16.0,1],[-2.302585093,6.0,58.0,6.0,16.0,1],[2.4069451083,4.0,62.0,3.0,16.0,1],[3.6913763343,3.0,44.0,3.0,17.0,1],[-2.302585093,5.0,30.0,6.0,17.0,1],[3.1398326175,3.0,76.0,5.0,17.0,1],[5.5987922608,4.0,50.0,4.0,17.0,1],[2.2082744135,6.0,41.0,4.0,17.0,1],[-2.302585093,6.0,77.0,3.0,17.0,1],[-2.302585093,6.0,35.0,6.0,17.0,1],[-2.302585093,4.0,39.0,4.0,17.0,1],[0.7419373447,4.0,72.0,3.0,17.0,1],[-2.302585093,6.0,42.0,7.0,17.0,1],[2.778819272,5.0,85.0,2.0,17.0,1],[8.8956433257,4.0,79.0,4.0,17.0,1],[-2.302585093,2.0,39.0,4.0,17.0,1],[3.1398326175,6.0,58.0,6.0,17.0,1],[3.7400477407,4.0,27.0,6.0,17.0,1],[0.7419373447,4.0,43.0,5.0,17.0,1],[-2.302585093,3.0,58.0,4.0,17.0,1],[3.7400477407,4.0,28.0,7.0,17.0,1],[6.152945438,5.0,27.0,6.0,17.0,1],[3.7400477407,3.0,40.0,3.0,17.0,1],[-2.302585093,1.0,43.0,6.0,17.0,1],[3.6913763343,5.0,64.0,3.0,17.0,1],[5.1935122522,2.0,39.0,6.0,17.0,1],[4.7013890437,4.0,76.0,4.0,17.0,1],[4.9423564533,3.0,64.0,5.0,17.0,1],[-2.302585093,4.0,28.0,4.0,17.0,1],[-2.302585093,4.0,45.0,3.0,17.0,1],[5.2475502495,6.0,22.0,3.0,17.0,1],[3.5582011305,3.0,27.0,6.0,17.0,1],[3.8088822465,1.0,31.0,4.0,17.0,1],[5.1363864994,2.0,34.0,6.0,17.0,1],[-2.302585093,2.0,30.0,4.0,17.0,1],[-2.302585093,6.0,64.0,3.0,17.0,1],[3.5582011305,6.0,36.0,6.0,17.0,1],[1.6292405397,4.0,31.0,2.0,17.0,1],[5.858218828,4.0,37.0,3.0,17.0,1],[1.4109869737,6.0,48.0,3.0,17.0,1],[4.249922794,5.0,41.0,3.0,17.0,1],[2.0918640617,5.0,25.0,4.0,17.0,1],[2.4932054526,4.0,82.0,3.0,17.0,1],[1.6292405397,6.0,36.0,7.0,17.0,1],[-2.302585093,6.0,47.0,3.0,17.0,1],[2.778819272,2.0,67.0,4.0,17.0,1],[-2.302585093,4.0,24.0,4.0,17.0,1],[2.2082744135,4.0,33.0,6.0,17.0,1],[2.6461747974,4.0,59.0,4.0,17.0,1],[3.0955776085,7.0,71.0,4.0,17.0,1],[-2.302585093,6.0,36.0,3.0,17.0,1],[0.0953101798,3.0,41.0,3.0,17.0,1],[7.3778214063,6.0,38.0,6.0,17.0,1],[8.8956433257,6.0,32.0,3.0,17.0,1],[2.9496883351,5.0,32.0,4.0,17.0,1],[2.2082744135,5.0,75.0,6.0,17.0,1],[-2.302585093,5.0,52.0,3.0,17.0,1],[7.3778214063,2.0,29.0,7.0,17.0,1],[2.4932054526,3.0,71.0,3.0,17.0,1],[0.0953101798,6.0,33.0,6.0,17.0,1],[-2.302585093,1.0,67.0,7.0,17.0,1],[-2.302585093,6.0,49.0,4.0,17.0,1],[-2.302585093,2.0,31.0,7.0,17.0,1],[2.2082744135,3.0,53.0,2.0,17.0,1],[-2.302585093,2.0,35.0,7.0,17.0,1],[5.1363864994,6.0,49.0,7.0,18.0,1],[1.1314021115,6.0,74.0,3.0,18.0,1],[2.6461747974,6.0,29.0,4.0,18.0,1],[0.0953101798,2.0,27.0,6.0,18.0,1],[3.1398326175,4.0,70.0,4.0,18.0,1],[-2.302585093,6.0,43.0,6.0,18.0,1],[0.0953101798,2.0,47.0,7.0,18.0,1],[-2.302585093,4.0,42.0,7.0,18.0,1],[2.2082744135,6.0,41.0,6.0,18.0,1],[4.8683033855,6.0,37.0,4.0,18.0,1],[1.6292405397,5.0,61.0,3.0,18.0,1],[1.4109869737,4.0,84.0,4.0,18.0,1],[7.9374104098,5.0,46.0,6.0,18.0,1],[1.4109869737,4.0,39.0,7.0,18.0,1],[1.8082887712,2.0,53.0,3.0,18.0,1],[1.4109869737,5.0,87.0,6.0,18.0,1],[4.432006567,4.0,51.0,3.0,18.0,1],[-2.302585093,5.0,37.0,5.0,18.0,1],[2.2082744135,4.0,37.0,6.0,18.0,1],[5.6702256911,5.0,40.0,6.0,18.0,1],[-2.302585093,4.0,46.0,6.0,18.0,1],[2.2082744135,1.0,44.0,3.0,18.0,1],[-2.302585093,4.0,37.0,3.0,18.0,1],[-2.302585093,4.0,55.0,7.0,18.0,1],[3.0955776085,5.0,40.0,6.0,18.0,1],[-2.302585093,3.0,42.0,7.0,18.0,1],[6.4616244141,6.0,40.0,3.0,18.0,1],[2.3125354238,6.0,32.0,3.0,18.0,1],[1.4109869737,5.0,58.0,7.0,18.0,1],[-2.302585093,5.0,37.0,3.0,18.0,1],[6.4616244141,4.0,51.0,3.0,18.0,1],[4.7013890437,3.0,44.0,5.0,18.0,1],[-2.302585093,4.0,23.0,2.0,18.0,1],[-2.302585093,6.0,38.0,3.0,18.0,1],[4.206184044,3.0,42.0,7.0,18.0,1],[6.2540211008,4.0,60.0,4.0,18.0,1],[-2.302585093,4.0,34.0,4.0,18.0,1],[3.9337844972,6.0,49.0,3.0,18.0,1],[-2.302585093,4.0,40.0,3.0,18.0,1],[7.9374104098,2.0,23.0,4.0,18.0,1],[4.7013890437,2.0,47.0,3.0,18.0,1],[8.8956433257,4.0,44.0,5.0,18.0,1],[8.8956433257,5.0,37.0,7.0,18.0,1],[-2.302585093,6.0,26.0,5.0,18.0,1],[2.778819272,7.0,51.0,4.0,18.0,1],[4.9423564533,4.0,69.0,3.0,18.0,1],[3.9908341859,2.0,36.0,6.0,18.0,1],[0.7419373447,2.0,28.0,4.0,18.0,1],[6.152945438,5.0,40.0,4.0,19.0,1],[-2.302585093,6.0,45.0,4.0,19.0,1],[4.3188205588,5.0,75.0,6.0,19.0,1],[2.4069451083,6.0,32.0,6.0,19.0,1],[-2.302585093,3.0,27.0,3.0,19.0,1],[7.9374104098,5.0,63.0,6.0,19.0,1],[4.9423564533,5.0,79.0,7.0,19.0,1],[2.2082744135,3.0,40.0,6.0,19.0,1],[8.8956433257,4.0,57.0,6.0,19.0,1],[3.8088822465,3.0,44.0,6.0,19.0,1],[7.3778214063,5.0,78.0,6.0,19.0,1],[2.2082744135,4.0,58.0,7.0,19.0,1],[-2.302585093,2.0,55.0,3.0,19.0,1],[4.8683033855,3.0,25.0,6.0,19.0,1],[2.2082744135,2.0,27.0,7.0,19.0,1],[8.1605468185,4.0,21.0,3.0,19.0,1],[-2.302585093,6.0,37.0,4.0,19.0,1],[-2.302585093,7.0,31.0,3.0,19.0,1],[3.5582011305,2.0,85.0,7.0,19.0,1],[6.8025058683,4.0,33.0,3.0,19.0,1],[3.2995337279,3.0,63.0,2.0,19.0,1],[6.8025058683,4.0,51.0,3.0,19.0,1],[-2.302585093,3.0,46.0,3.0,19.0,1],[4.1604443639,5.0,26.0,5.0,19.0,1],[1.4109869737,3.0,57.0,6.0,19.0,1],[-2.302585093,4.0,48.0,3.0,19.0,1],[-2.302585093,7.0,55.0,3.0,19.0,1],[3.9721769282,3.0,37.0,5.0,19.0,1],[5.6702256911,6.0,39.0,3.0,19.0,1],[2.7146947438,2.0,24.0,3.0,19.0,1],[-2.302585093,6.0,30.0,6.0,19.0,1],[3.5582011305,3.0,36.0,7.0,19.0,1],[-2.302585093,5.0,45.0,3.0,19.0,1],[6.152945438,5.0,29.0,3.0,19.0,1],[2.778819272,6.0,41.0,4.0,19.0,1],[3.6913763343,5.0,28.0,5.0,19.0,1],[5.6702256911,2.0,35.0,4.0,19.0,1],[1.4109869737,2.0,46.0,4.0,19.0,1],[0.0953101798,1.0,55.0,4.0,19.0,1],[4.9423564533,2.0,65.0,4.0,19.0,1],[4.7013890437,4.0,22.0,4.0,19.0,1],[-2.302585093,4.0,41.0,4.0,19.0,1],[6.8025058683,2.0,43.0,7.0,19.0,1],[-2.302585093,4.0,49.0,4.0,19.0,1],[-2.302585093,4.0,35.0,7.0,19.0,1],[3.9337844972,3.0,80.0,3.0,19.0,1],[4.2640873368,4.0,57.0,4.0,19.0,1],[6.8025058683,3.0,48.0,3.0,19.0,1],[4.4200447019,1.0,43.0,6.0,19.0,1],[5.8863817707,4.0,34.0,4.0,19.0,1],[5.1935122522,2.0,44.0,5.0,19.0,1],[0.0953101798,6.0,49.0,6.0,20.0,1],[3.0955776085,5.0,43.0,7.0,20.0,1],[0.0953101798,4.0,39.0,4.0,20.0,1],[0.7419373447,4.0,27.0,3.0,20.0,1],[3.5292973843,6.0,30.0,6.0,20.0,1],[3.4995332824,6.0,33.0,6.0,20.0,1],[2.3125354238,2.0,32.0,5.0,20.0,1],[5.6702256911,5.0,31.0,6.0,20.0,1],[-2.302585093,5.0,27.0,5.0,20.0,1],[4.3320482649,2.0,36.0,4.0,20.0,1],[3.0007198151,3.0,45.0,5.0,20.0,1],[-2.302585093,4.0,51.0,3.0,20.0,1],[-2.302585093,6.0,36.0,4.0,20.0,1],[-2.302585093,6.0,47.0,7.0,20.0,1],[6.152945438,4.0,42.0,6.0,20.0,1],[2.2082744135,6.0,70.0,6.0,20.0,1],[-2.302585093,3.0,40.0,4.0,20.0,1],[-2.302585093,2.0,38.0,3.0,20.0,1],[2.0918640617,5.0,29.0,3.0,20.0,1],[0.0953101798,4.0,58.0,3.0,20.0,1],[0.0953101798,4.0,28.0,3.0,20.0,1],[1.960094784,6.0,30.0,4.0,20.0,1],[-2.302585093,4.0,48.0,5.0,20.0,1],[5.1363864994,6.0,35.0,4.0,20.0,1],[5.5987922608,6.0,38.0,3.0,20.0,1],[-2.302585093,4.0,56.0,7.0,20.0,1],[2.5726122302,5.0,62.0,4.0,20.0,1],[2.3125354238,6.0,56.0,4.0,20.0,1],[3.0955776085,6.0,32.0,3.0,20.0,1],[6.4616244141,4.0,50.0,5.0,20.0,1],[6.8025058683,3.0,45.0,6.0,20.0,1],[3.0955776085,3.0,36.0,6.0,20.0,1],[4.1287459889,6.0,49.0,4.0,20.0,1],[4.7013890437,7.0,31.0,6.0,20.0,1],[4.432006567,2.0,33.0,7.0,20.0,1],[-2.302585093,6.0,35.0,4.0,20.0,1],[2.5726122302,4.0,73.0,4.0,20.0,1],[3.0007198151,6.0,54.0,5.0,20.0,1],[-2.302585093,4.0,48.0,3.0,20.0,1],[2.778819272,6.0,65.0,4.0,20.0,1],[1.8082887712,5.0,46.0,4.0,20.0,1],[2.4932054526,2.0,45.0,7.0,20.0,1],[-2.302585093,6.0,65.0,7.0,20.0,1],[-2.302585093,6.0,45.0,6.0,20.0,1],[5.1363864994,4.0,89.0,7.0,20.0,1],[4.6061696863,5.0,32.0,4.0,20.0,1],[1.6292405397,6.0,38.0,4.0,20.0,1],[8.1605468185,2.0,33.0,4.0,20.0,1],[4.2640873368,6.0,49.0,7.0,20.0,1],[1.4109869737,5.0,64.0,6.0,20.0,1],[8.8956433257,5.0,55.0,4.0,20.0,1],[1.960094784,3.0,56.0,7.0,20.0,1],[5.6702256911,4.0,30.0,6.0,20.0,1],[-2.302585093,5.0,41.0,7.0,20.0,1],[-2.302585093,6.0,39.0,5.0,20.0,1],[6.2540211008,4.0,34.0,3.0,20.0,1],[6.0640177398,4.0,53.0,3.0,20.0,1],[2.2082744135,3.0,40.0,6.0,20.0,1],[3.6913763343,3.0,48.0,6.0,20.0,1],[0.7419373447,6.0,59.0,4.0,20.0,1],[4.3188205588,6.0,54.0,4.0,20.0,1],[5.1363864994,3.0,41.0,6.0,20.0,1],[5.1363864994,2.0,41.0,6.0,20.0,1],[6.4616244141,5.0,63.0,7.0,20.0,1],[7.9374104098,7.0,39.0,3.0,20.0,1],[2.2082744135,7.0,46.0,3.0,20.0,1],[5.0113017386,4.0,55.0,3.0,20.0,1],[-2.302585093,4.0,42.0,3.0,20.0,1],[-2.302585093,6.0,58.0,2.0,20.0,1],[4.6061696863,3.0,42.0,4.0,20.0,1],[3.4995332824,4.0,40.0,6.0,20.0,1],[5.7368948261,5.0,56.0,6.0,20.0,1],[3.9721769282,4.0,37.0,4.0,20.0,1],[2.5726122302,3.0,37.0,6.0,20.0,1],[5.6702256911,5.0,49.0,6.0,20.0,1],[5.7368948261,6.0,63.0,4.0,20.0,1],[-2.302585093,6.0,30.0,7.0,20.0,1],[3.9908341859,4.0,62.0,5.0,20.0,1],[7.3778214063,4.0,30.0,6.0,20.0,1],[2.6461747974,6.0,34.0,6.0,20.0,1],[3.2228678461,6.0,41.0,4.0,20.0,1],[3.8088822465,4.0,43.0,3.0,20.0,1],[3.0007198151,5.0,33.0,5.0,20.0,1],[2.8959119383,4.0,67.0,7.0,20.0,1],[6.6067853122,5.0,55.0,5.0,20.0,1],[2.2082744135,2.0,33.0,5.0,20.0,1],[1.6292405397,6.0,61.0,4.0,20.0,1],[8.8956433257,4.0,45.0,3.0,20.0,1],[4.3956829611,4.0,34.0,3.0,20.0,1],[5.2475502495,6.0,35.0,3.0,20.0,1],[3.9337844972,4.0,50.0,6.0,20.0,1],[8.8956433257,3.0,38.0,4.0,20.0,1],[5.858218828,6.0,56.0,3.0,20.0,1],[3.2995337279,4.0,31.0,3.0,20.0,1],[3.4995332824,6.0,40.0,7.0,20.0,1],[3.9140210081,3.0,44.0,3.0,20.0,1],[0.0953101798,6.0,39.0,4.0,20.0,1],[2.4069451083,4.0,45.0,3.0,20.0,1],[3.9337844972,3.0,72.0,6.0,20.0,1],[5.07579862,2.0,44.0,7.0,20.0,1],[2.778819272,1.0,61.0,7.0,21.0,1],[4.7013890437,6.0,34.0,7.0,21.0,1],[4.7013890437,5.0,61.0,6.0,21.0,1],[2.5726122302,3.0,67.0,4.0,21.0,1],[5.3940819885,4.0,38.0,6.0,21.0,1],[6.152945438,4.0,50.0,6.0,21.0,1],[3.0955776085,6.0,62.0,4.0,21.0,1],[2.2082744135,6.0,36.0,6.0,21.0,1],[3.0955776085,6.0,50.0,6.0,21.0,1],[5.2475502495,4.0,30.0,6.0,21.0,1],[4.6061696863,6.0,59.0,5.0,21.0,1],[2.6461747974,3.0,62.0,6.0,21.0,1],[-2.302585093,4.0,40.0,4.0,21.0,1],[5.1935122522,6.0,30.0,4.0,21.0,1],[1.1314021115,3.0,47.0,3.0,21.0,1],[3.9337844972,5.0,41.0,6.0,21.0,1],[2.2082744135,6.0,35.0,7.0,21.0,1],[-2.302585093,5.0,45.0,4.0,21.0,1],[-2.302585093,4.0,34.0,6.0,21.0,1],[4.2640873368,5.0,55.0,3.0,21.0,1],[5.6702256911,5.0,37.0,4.0,21.0,1],[3.8088822465,5.0,61.0,7.0,21.0,1],[-2.302585093,4.0,62.0,2.0,21.0,1],[3.2619353143,5.0,54.0,6.0,21.0,1],[4.4670568839,2.0,33.0,6.0,21.0,1],[-2.302585093,2.0,50.0,6.0,21.0,1],[6.4458785369,3.0,37.0,3.0,21.0,1],[3.9140210081,5.0,44.0,3.0,21.0,1],[3.5582011305,4.0,78.0,3.0,21.0,1],[5.1935122522,6.0,56.0,3.0,21.0,1],[3.4688560301,2.0,29.0,6.0,21.0,1],[-2.302585093,3.0,52.0,6.0,21.0,1],[3.9337844972,6.0,31.0,3.0,21.0,1],[3.6913763343,6.0,34.0,7.0,21.0,1],[-2.302585093,5.0,31.0,7.0,21.0,1],[-2.302585093,4.0,43.0,6.0,21.0,1],[-2.302585093,4.0,31.0,3.0,21.0,1],[0.0953101798,6.0,63.0,7.0,21.0,1],[1.960094784,2.0,38.0,4.0,21.0,1],[-2.302585093,6.0,31.0,5.0,21.0,1],[4.2640873368,2.0,64.0,3.0,21.0,1],[4.3188205588,3.0,55.0,7.0,21.0,1],[4.0091497162,2.0,41.0,3.0,21.0,1],[5.6702256911,3.0,38.0,4.0,21.0,1],[4.4784725329,6.0,28.0,6.0,21.0,1],[-2.302585093,4.0,42.0,5.0,21.0,1],[2.778819272,2.0,43.0,4.0,21.0,1],[4.3188205588,5.0,37.0,4.0,21.0,1],[5.3940819885,4.0,47.0,5.0,21.0,1],[1.1314021115,5.0,52.0,7.0,21.0,1],[4.8683033855,5.0,32.0,4.0,21.0,1],[-2.302585093,4.0,29.0,3.0,21.0,1],[4.7013890437,6.0,56.0,3.0,21.0,1],[2.4932054526,4.0,63.0,7.0,21.0,1],[5.1935122522,3.0,35.0,5.0,21.0,1],[4.5336741843,4.0,36.0,4.0,21.0,1],[5.1363864994,4.0,75.0,5.0,21.0,1],[3.4372078192,3.0,48.0,6.0,21.0,1],[4.1287459889,7.0,36.0,5.0,21.0,1],[3.4045251718,4.0,34.0,6.0,21.0,1],[4.1911687469,4.0,35.0,5.0,21.0,1],[1.1314021115,5.0,50.0,4.0,21.0,1],[2.8959119383,5.0,39.0,7.0,21.0,1],[5.858218828,5.0,70.0,7.0,21.0,1],[4.2640873368,4.0,76.0,3.0,21.0,1],[8.1605468185,5.0,35.0,6.0,21.0,1],[-2.302585093,3.0,53.0,7.0,21.0,1],[5.8863817707,5.0,46.0,6.0,21.0,1],[4.3956829611,5.0,34.0,4.0,21.0,1],[5.858218828,4.0,69.0,4.0,21.0,1],[5.2475502495,5.0,32.0,3.0,21.0,1],[-2.302585093,5.0,50.0,2.0,21.0,1],[5.6702256911,5.0,35.0,6.0,21.0,1],[2.8959119383,6.0,67.0,5.0,21.0,1],[2.4069451083,5.0,47.0,3.0,21.0,1],[0.7419373447,6.0,50.0,6.0,21.0,1],[6.345811784,6.0,32.0,3.0,21.0,1],[5.7368948261,5.0,58.0,5.0,21.0,1],[0.0953101798,3.0,49.0,7.0,21.0,1],[-2.302585093,6.0,43.0,4.0,21.0,1],[3.5582011305,5.0,24.0,6.0,21.0,1],[3.0955776085,5.0,58.0,7.0,21.0,1],[0.7419373447,2.0,43.0,4.0,21.0,1],[-2.302585093,4.0,59.0,3.0,21.0,1],[-2.302585093,6.0,40.0,5.0,21.0,1],[5.7368948261,5.0,35.0,4.0,21.0,1],[6.152945438,2.0,48.0,4.0,21.0,1],[-2.302585093,6.0,40.0,3.0,21.0,1],[5.5987922608,3.0,48.0,3.0,21.0,1],[4.7013890437,2.0,47.0,7.0,21.0,1],[3.9140210081,6.0,23.0,3.0,21.0,1],[-2.302585093,6.0,38.0,3.0,21.0,1],[1.1314021115,6.0,81.0,7.0,21.0,1],[3.4372078192,3.0,48.0,6.0,21.0,1],[3.0955776085,5.0,52.0,3.0,21.0,1],[4.4200447019,4.0,24.0,6.0,21.0,1],[2.2082744135,4.0,21.0,5.0,21.0,1],[1.6292405397,5.0,70.0,6.0,21.0,1],[-2.302585093,7.0,24.0,6.0,21.0,1],[-2.302585093,4.0,57.0,7.0,21.0,1],[-2.302585093,3.0,37.0,6.0,21.0,1],[3.2995337279,3.0,25.0,5.0,21.0,1],[4.7013890437,6.0,33.0,3.0,21.0,1],[-2.302585093,4.0,45.0,3.0,22.0,1],[-2.302585093,5.0,42.0,6.0,22.0,1],[5.858218828,3.0,47.0,6.0,22.0,1],[-2.302585093,6.0,51.0,7.0,22.0,1],[1.6292405397,5.0,85.0,2.0,22.0,1],[2.7146947438,3.0,32.0,7.0,22.0,1],[3.5582011305,3.0,31.0,7.0,22.0,1],[-2.302585093,4.0,23.0,6.0,22.0,1],[4.3188205588,3.0,42.0,6.0,22.0,1],[-2.302585093,6.0,55.0,6.0,22.0,1],[2.778819272,6.0,45.0,6.0,22.0,1],[-2.302585093,6.0,35.0,7.0,22.0,1],[-2.302585093,2.0,45.0,6.0,22.0,1],[-2.302585093,3.0,42.0,3.0,22.0,1],[1.4109869737,6.0,37.0,4.0,22.0,1],[4.1287459889,4.0,38.0,3.0,22.0,1],[-2.302585093,2.0,47.0,7.0,22.0,1],[1.4109869737,4.0,32.0,6.0,22.0,1],[4.0271358125,5.0,35.0,6.0,22.0,1],[0.7419373447,4.0,38.0,4.0,22.0,1],[-2.302585093,4.0,40.0,3.0,22.0,1],[4.3188205588,6.0,62.0,6.0,22.0,1],[2.3125354238,2.0,28.0,7.0,22.0,1],[-2.302585093,6.0,59.0,5.0,22.0,1],[-2.302585093,1.0,25.0,6.0,22.0,1],[5.3940819885,4.0,31.0,6.0,22.0,1],[-2.302585093,7.0,45.0,4.0,22.0,1],[4.3188205588,5.0,42.0,6.0,22.0,1],[-2.302585093,2.0,56.0,7.0,22.0,1],[4.9423564533,3.0,47.0,7.0,22.0,1],[5.6702256911,6.0,38.0,6.0,22.0,1],[5.858218828,4.0,47.0,6.0,22.0,1],[4.0091497162,5.0,49.0,4.0,22.0,1],[3.4372078192,3.0,29.0,7.0,22.0,1],[2.8390784635,2.0,57.0,6.0,22.0,1],[3.9337844972,6.0,68.0,3.0,22.0,1],[4.9423564533,2.0,76.0,6.0,22.0,1],[2.2082744135,6.0,66.0,6.0,22.0,1],[-2.302585093,5.0,59.0,4.0,22.0,1],[6.4616244141,5.0,37.0,7.0,22.0,1],[3.4688560301,5.0,38.0,6.0,22.0,1],[1.6292405397,6.0,47.0,7.0,22.0,1],[2.0918640617,5.0,36.0,7.0,22.0,1],[2.8959119383,5.0,45.0,7.0,22.0,1],[-2.302585093,5.0,39.0,7.0,22.0,1],[-2.302585093,3.0,34.0,6.0,22.0,1],[-2.302585093,6.0,49.0,4.0,22.0,1],[3.4372078192,6.0,36.0,6.0,22.0,1],[5.858218828,6.0,81.0,5.0,22.0,1],[3.0007198151,5.0,29.0,4.0,22.0,1],[4.249922794,5.0,45.0,6.0,22.0,1],[3.4372078192,5.0,21.0,4.0,22.0,1],[1.1314021115,2.0,33.0,6.0,22.0,1],[2.2082744135,4.0,44.0,3.0,23.0,1],[4.0792309244,2.0,52.0,7.0,23.0,1],[3.2995337279,3.0,38.0,4.0,23.0,1],[3.9337844972,2.0,44.0,5.0,23.0,1],[2.2082744135,6.0,87.0,7.0,23.0,1],[-2.302585093,7.0,22.0,3.0,23.0,1],[4.4784725329,3.0,32.0,6.0,23.0,1],[4.206184044,4.0,69.0,3.0,23.0,1],[3.3707381742,6.0,49.0,6.0,23.0,1],[1.6292405397,6.0,53.0,3.0,23.0,1],[-2.302585093,6.0,44.0,6.0,23.0,1],[6.8025058683,6.0,34.0,6.0,23.0,1],[2.8959119383,6.0,55.0,7.0,23.0,1],[5.2475502495,3.0,35.0,6.0,23.0,1],[0.7419373447,4.0,55.0,3.0,23.0,1],[1.6292405397,6.0,27.0,6.0,23.0,1],[4.0271358125,4.0,26.0,6.0,23.0,1],[4.3188205588,4.0,54.0,6.0,23.0,1],[4.0271358125,5.0,42.0,4.0,23.0,1],[-2.302585093,6.0,57.0,7.0,23.0,1],[-2.302585093,7.0,54.0,6.0,23.0,1],[4.3188205588,6.0,55.0,6.0,23.0,1],[7.3778214063,5.0,50.0,7.0,23.0,1],[2.7146947438,5.0,57.0,7.0,23.0,1],[2.9496883351,5.0,46.0,4.0,23.0,1],[2.778819272,6.0,53.0,6.0,23.0,1],[3.7400477407,3.0,32.0,7.0,23.0,1],[2.8959119383,5.0,53.0,5.0,23.0,1],[-2.302585093,3.0,39.0,6.0,23.0,1],[5.7368948261,5.0,47.0,6.0,23.0,1],[7.3778214063,5.0,57.0,4.0,23.0,1],[3.1398326175,6.0,49.0,6.0,23.0,1],[3.0007198151,5.0,31.0,5.0,23.0,1],[3.9337844972,5.0,43.0,6.0,23.0,1],[-2.302585093,5.0,44.0,6.0,23.0,1],[-2.302585093,4.0,39.0,6.0,23.0,1],[-2.302585093,6.0,49.0,4.0,23.0,1],[2.8959119383,5.0,72.0,6.0,23.0,1],[8.8956433257,5.0,50.0,6.0,23.0,1],[4.7013890437,5.0,28.0,4.0,23.0,1],[-2.302585093,5.0,48.0,7.0,23.0,1],[8.1605468185,3.0,32.0,6.0,23.0,1],[6.5793900913,5.0,63.0,4.0,23.0,1],[2.2082744135,4.0,36.0,4.0,23.0,1],[3.852273001,6.0,36.0,6.0,23.0,1],[5.858218828,3.0,53.0,3.0,23.0,1],[-2.302585093,2.0,44.0,7.0,23.0,1],[-2.302585093,4.0,41.0,7.0,24.0,1],[4.4200447019,2.0,56.0,7.0,24.0,1],[0.0953101798,4.0,63.0,7.0,24.0,1],[5.2475502495,2.0,52.0,6.0,24.0,1],[-2.302585093,3.0,43.0,7.0,24.0,1],[2.4932054526,4.0,40.0,3.0,24.0,1],[2.2082744135,5.0,69.0,4.0,24.0,1],[3.1398326175,2.0,49.0,7.0,24.0,1],[2.2082744135,3.0,65.0,7.0,24.0,1],[2.8959119383,6.0,53.0,7.0,24.0,1],[-2.302585093,5.0,50.0,4.0,24.0,1],[2.4932054526,2.0,27.0,5.0,24.0,1],[-2.302585093,5.0,44.0,6.0,24.0,1],[5.1363864994,2.0,54.0,7.0,24.0,1],[-2.302585093,4.0,33.0,5.0,24.0,1],[2.2082744135,4.0,48.0,7.0,24.0,1],[3.1398326175,5.0,54.0,5.0,24.0,1],[-2.302585093,6.0,56.0,3.0,24.0,1],[2.2082744135,2.0,34.0,7.0,24.0,1],[5.6702256911,6.0,41.0,6.0,24.0,1],[0.0953101798,5.0,40.0,6.0,24.0,1],[5.858218828,7.0,55.0,6.0,24.0,1],[3.0007198151,4.0,38.0,6.0,24.0,1],[-2.302585093,6.0,40.0,6.0,24.0,1],[3.1398326175,6.0,46.0,4.0,24.0,1],[5.0113017386,3.0,26.0,6.0,24.0,1],[3.4372078192,5.0,49.0,6.0,24.0,1],[-2.302585093,4.0,51.0,5.0,24.0,1],[2.2082744135,5.0,46.0,6.0,24.0,1],[3.852273001,3.0,40.0,7.0,24.0,1],[6.8025058683,3.0,30.0,5.0,24.0,1],[4.4200447019,2.0,45.0,5.0,24.0,1],[2.8959119383,5.0,52.0,7.0,24.0,1],[-2.302585093,6.0,36.0,6.0,24.0,1],[3.0007198151,4.0,49.0,6.0,24.0,1],[3.1822118405,3.0,38.0,7.0,24.0,1],[2.8959119383,2.0,51.0,7.0,24.0,1],[2.2082744135,3.0,47.0,6.0,24.0,1],[-2.302585093,6.0,52.0,7.0,24.0,1],[2.2082744135,6.0,33.0,6.0,24.0,1],[-2.302585093,4.0,50.0,4.0,24.0,1],[2.8959119383,6.0,48.0,7.0,24.0,1],[2.9496883351,2.0,36.0,6.0,24.0,1],[3.4372078192,2.0,35.0,7.0,24.0,1],[8.1605468185,7.0,34.0,7.0,24.0,1],[-2.302585093,2.0,53.0,6.0,24.0,1],[3.4995332824,4.0,33.0,7.0,24.0,1],[-2.302585093,6.0,52.0,6.0,24.0,1],[2.8959119383,4.0,44.0,7.0,24.0,1],[-2.302585093,3.0,48.0,6.0,24.0,1],[3.4372078192,5.0,20.0,4.0,24.0,1],[-2.302585093,3.0,45.0,6.0,24.0,1],[4.0792309244,4.0,70.0,3.0,24.0,1],[-2.302585093,3.0,39.0,3.0,24.0,1],[8.8956433257,3.0,40.0,7.0,24.0,1],[4.3188205588,5.0,62.0,6.0,24.0,1],[-2.302585093,5.0,46.0,6.0,24.0,1],[3.2995337279,4.0,46.0,3.0,24.0,1],[7.3778214063,4.0,56.0,7.0,24.0,1],[-2.302585093,6.0,55.0,7.0,24.0,1],[-2.302585093,6.0,41.0,4.0,24.0,1],[8.8956433257,2.0,43.0,7.0,24.0,1],[2.778819272,7.0,34.0,3.0,24.0,1],[-2.302585093,7.0,73.0,6.0,24.0,1],[-2.302585093,5.0,50.0,6.0,24.0,1],[-2.302585093,6.0,43.0,6.0,24.0,1],[-2.302585093,6.0,46.0,7.0,24.0,1],[2.8959119383,4.0,61.0,7.0,24.0,1]];
	  //var endog = [6.0,1.0,1.0,1.0,0.0,1.0,1.0,4.0,3.0,0.0,4.0,1.0,5.0,0.0,0.0,0.0,1.0,1.0,5.0,0.0,2.0,2.0,2.0,6.0,1.0,1.0,1.0,0.0,1.0,0.0,2.0,1.0,0.0,1.0,4.0,0.0,1.0,5.0,6.0,1.0,0.0,5.0,1.0,6.0,2.0,2.0,6.0,0.0,1.0,2.0,5.0,5.0,3.0,0.0,0.0,5.0,2.0,0.0,6.0,0.0,0.0,0.0,2.0,1.0,0.0,1.0,0.0,4.0,4.0,6.0,5.0,1.0,6.0,3.0,1.0,2.0,0.0,1.0,2.0,3.0,3.0,1.0,2.0,0.0,4.0,0.0,5.0,0.0,6.0,0.0,1.0,2.0,6.0,6.0,1.0,1.0,5.0,6.0,5.0,4.0,0.0,5.0,1.0,4.0,0.0,0.0,1.0,6.0,0.0,1.0,0.0,0.0,0.0,6.0,4.0,3.0,0.0,4.0,2.0,2.0,0.0,6.0,0.0,6.0,4.0,3.0,0.0,0.0,6.0,2.0,3.0,1.0,5.0,6.0,1.0,4.0,0.0,0.0,3.0,5.0,0.0,1.0,3.0,1.0,0.0,4.0,0.0,1.0,0.0,0.0,6.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,1.0,1.0,5.0,1.0,1.0,5.0,5.0,4.0,0.0,0.0,0.0,4.0,1.0,5.0,5.0,6.0,0.0,1.0,1.0,0.0,1.0,5.0,6.0,0.0,0.0,0.0,3.0,5.0,1.0,2.0,1.0,6.0,1.0,2.0,1.0,5.0,5.0,0.0,0.0,0.0,1.0,5.0,0.0,5.0,5.0,6.0,5.0,1.0,0.0,6.0,5.0,1.0,6.0,1.0,2.0,5.0,1.0,5.0,1.0,2.0,0.0,2.0,3.0,5.0,2.0,2.0,0.0,0.0,1.0,0.0,6.0,2.0,5.0,0.0,4.0,0.0,4.0,0.0,0.0,2.0,3.0,0.0,2.0,0.0,2.0,0.0,5.0,6.0,1.0,6.0,6.0,0.0,0.0,0.0,2.0,4.0,6.0,1.0,1.0,4.0,4.0,1.0,2.0,5.0,1.0,4.0,1.0,2.0,0.0,1.0,1.0,0.0,2.0,0.0,1.0,2.0,2.0,6.0,1.0,6.0,0.0,1.0,1.0,5.0,0.0,4.0,1.0,5.0,4.0,2.0,4.0,4.0,5.0,0.0,4.0,4.0,1.0,6.0,5.0,2.0,1.0,6.0,5.0,6.0,1.0,0.0,1.0,0.0,0.0,6.0,1.0,6.0,0.0,0.0,1.0,0.0,5.0,1.0,5.0,2.0,1.0,0.0,1.0,5.0,6.0,0.0,5.0,1.0,2.0,5.0,1.0,1.0,5.0,5.0,1.0,0.0,2.0,0.0,1.0,1.0,6.0,0.0,0.0,0.0,1.0,2.0,1.0,5.0,5.0,0.0,4.0,6.0,5.0,5.0,4.0,5.0,2.0,6.0,5.0,6.0,5.0,1.0,0.0,4.0,2.0,0.0,0.0,0.0,6.0,6.0,6.0,1.0,5.0,0.0,5.0,1.0,1.0,6.0,0.0,6.0,0.0,6.0,0.0,1.0,4.0,1.0,0.0,5.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,1.0,6.0,2.0,6.0,6.0,0.0,0.0,0.0,1.0,1.0,6.0,0.0,2.0,6.0,6.0,0.0,6.0,6.0,1.0,1.0,6.0,0.0,1.0,5.0,6.0,6.0,3.0,4.0,6.0,5.0,3.0,0.0,6.0,5.0,1.0,0.0,4.0,5.0,2.0,0.0,5.0,0.0,4.0,0.0,2.0,1.0,6.0,1.0,0.0,0.0,0.0,6.0,4.0,4.0,5.0,1.0,3.0,5.0,6.0,4.0,1.0,0.0,5.0,5.0,1.0,6.0,6.0,0.0,6.0,6.0,1.0,0.0,4.0,0.0,0.0,2.0,2.0,6.0,1.0,1.0,0.0,6.0,0.0,6.0,0.0,5.0,6.0,2.0,0.0,6.0,6.0,1.0,0.0,0.0,5.0,0.0,6.0,0.0,4.0,4.0,6.0,2.0,3.0,1.0,2.0,1.0,1.0,6.0,6.0,4.0,4.0,5.0,5.0,0.0,6.0,0.0,4.0,1.0,6.0,4.0,0.0,0.0,0.0,1.0,5.0,2.0,0.0,0.0,2.0,5.0,5.0,5.0,5.0,1.0,3.0,6.0,1.0,1.0,1.0,6.0,5.0,1.0,2.0,0.0,2.0,5.0,5.0,0.0,5.0,3.0,1.0,0.0,6.0,0.0,1.0,5.0,1.0,6.0,1.0,6.0,1.0,4.0,2.0,5.0,4.0,0.0,0.0,1.0,6.0,1.0,1.0,2.0,0.0,4.0,1.0,0.0,0.0,2.0,0.0,0.0,4.0,2.0,6.0,1.0,6.0,4.0,0.0,6.0,2.0,0.0,2.0,2.0,5.0,4.0,1.0,6.0,3.0,0.0,4.0,6.0,2.0,5.0,2.0,6.0,0.0,4.0,5.0,5.0,6.0,1.0,1.0,0.0,6.0,6.0,2.0,6.0,4.0,6.0,1.0,4.0,6.0,0.0,6.0,6.0,4.0,4.0,1.0,5.0,6.0,5.0,1.0,1.0,5.0,5.0,6.0,4.0,1.0,2.0,1.0,5.0,4.0,1.0,0.0,4.0,4.0,4.0,0.0,3.0,4.0,2.0,2.0,1.0,2.0,2.0,5.0,6.0,6.0,4.0,1.0,6.0,5.0,6.0,4.0,5.0,0.0,0.0,5.0,4.0,0.0,6.0,2.0,0.0,5.0,5.0,5.0,0.0,2.0,1.0,0.0,1.0,0.0,6.0,5.0,1.0,6.0,1.0,6.0,5.0,4.0,1.0,6.0,0.0,3.0,6.0,2.0,1.0,6.0,6.0,4.0,2.0,2.0,4.0,1.0,6.0,1.0,1.0,2.0,3.0,3.0,6.0,2.0,4.0,1.0,6.0,5.0,2.0,5.0,6.0,4.0,6.0,0.0,5.0,0.0,5.0,5.0,5.0,1.0,5.0,3.0,5.0,5.0,2.0,4.0,5.0,1.0,3.0,0.0,1.0,6.0,2.0,1.0,6.0,6.0,5.0,6.0,5.0,3.0,4.0,4.0,5.0,1.0,6.0,6.0,6.0,5.0,4.0,4.0,2.0,0.0,1.0,5.0,2.0,0.0,5.0,6.0,0.0,1.0,6.0,0.0,0.0,1.0,6.0,6.0,1.0,4.0,3.0,1.0,5.0,6.0,1.0,4.0,5.0,1.0,0.0,5.0,2.0,6.0,5.0,2.0,2.0,2.0,0.0,5.0,6.0,6.0,0.0,2.0,5.0,5.0,1.0,2.0,5.0,5.0,3.0,6.0,1.0,6.0,0.0,6.0,6.0,5.0,1.0,1.0,5.0,2.0,6.0,2.0,0.0,6.0,0.0,5.0,4.0,4.0,6.0,5.0,5.0,0.0,5.0,1.0,0.0,5.0,6.0,4.0,0.0,5.0,6.0,2.0,4.0,1.0,2.0,6.0,5.0,2.0,4.0,6.0,6.0,5.0,5.0,5.0,0.0,3.0,5.0,1.0,5.0,5.0,6.0,6.0,6.0,6.0,1.0,3.0,6.0,0.0,3.0,1.0,4.0,2.0,6.0,5.0,5.0,4.0,0.0,5.0,4.0,5.0,6.0,3.0,1.0,1.0,5.0,6.0,2.0,2.0,6.0,1.0,2.0,0.0,2.0,2.0,4.0,0.0,2.0,5.0,6.0,0.0,5.0,0.0,4.0,3.0,5.0,6.0,2.0,6.0,6.0,6.0,5.0,6.0,6.0,0.0,3.0,6.0,4.0,2.0,2.0,2.0,4.0,6.0,3.0,1.0,1.0,1.0,6.0,6.0,6.0,4.0,0.0,1.0,4.0,2.0,2.0,6.0,4.0,0.0,5.0,6.0,2.0,2.0,1.0,5.0,4.0,2.0,6.0,6.0,6.0,0.0,6.0,4.0,6.0,5.0,6.0,3.0];
      var model = jStat.models.ols(endog,exog);
      var tol   = 0.01;

      // coff estimate
      assert.epsilon(tol, model.coef[0], 10.0395 );
      assert.epsilon(tol, model.coef[1], 0.9928 );
	  /*
      assert.epsilon(tol, model.coef[2], -0.0033);
      assert.epsilon(tol, model.coef[3], 0.1608);
      assert.epsilon(tol, model.coef[4], 0.0520);
      assert.epsilon(tol, model.coef[5], -2.6639);
	  */
      //R2
      assert.epsilon(tol, model.R2, 0.9988);
      // f test
      assert.epsilon(tol, model.f.pvalue, 0.0000);
    }
  }
});

suite.export(module);
