/**
 * 获取水印图片，水印的文字信息需要在管理后台进行个性化配置
 *
 * \ **API目录**：设备
 *
 * @apiName 获取水印图片
 *
 * @param pageInfo string 否 表示当前应用在安全中心所属的页面，可以不传
 *
 * @returns
 * image string 水印的base64字符串
 *
 * @support
 *  - IOS v2.8.0
 *  - Android v2.8.0
 *  - PC v2.8.0
 * @example
 * ```typescript
 *  getWaterMarkV2()
 *   .then(res => {
 *     console.log(res);
 *   })
 *   .catch(err => {
 *     console.log(err);
 *   });
 * ```
 */
import { PageInfoEnum } from './packages/h5-watermark/generateWaterMarkV2';
export default function getWaterMarkV2(pageInfo?: PageInfoEnum): Promise<string>;
