/**
 * 替换页面
 *
 * \ **API目录**：导航
 *
 * @apiName 替换页面
 *
 * @param url string 是 替换页面的url
 *
 * @support
 *  - IOS v1.3.2
 *  - Android v1.3.2
 *
 * @example
 * ```typescript
 * replacePage({
 *    url: 'https://www.dg-work.cn'
 * })
 *   .then(res => {
 *     console.log(res);
 *   })
 *   .catch(err => {
 *     console.log(err);
 *   });
 * ```
 */
export interface ReplacePageParams {
    url: string;
    onSuccess?: () => void;
    onFail?: () => void;
}
declare function replacePage(params: ReplacePageParams): Promise<{}>;
declare namespace replacePage {
    var version: {
        android: string;
        ios: string;
    };
}
export default replacePage;
