package com.artfess.sysConfig.persistence.dao;

import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.sysConfig.persistence.model.SysSwiftMenu;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 
 * <pre> 
 * 描述：用户自定义菜单 DAO接口
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2018-06-29 14:27:46
 * 版权：广州宏天软件有限公司
 * </pre>
 */
public interface SysSwiftMenuDao extends BaseMapper<SysSwiftMenu> {

    /**
    * @Description: 获取超级管理员的自定义菜单
    * @param userId 用户ID
    * @param parentMenuPath 父级菜单路径
    * @Return: java.util.List<com.artfess.sysConfig.persistence.model.SysMenu>
    * @Author: chens
    * @Date: 2023/12/4 15:56
    */
    List<SysMenu> getSwiftMenuByAdmin(@Param("userId") String userId,@Param("parentMenuPath") String parentMenuPath);
    /**
     * 获取用户对应的快捷菜单
     * @param roles
     * @return
     */
    List<SysMenu> getSwiftMenuByUserId(@Param("userId") String userId,@Param("roles") List<String> roles,@Param("parentMenuPath") String parentMenuPath, @Param("tenantId") String tenantId, @Param(
            "ignoreMenus") List<String> ignoreMenus);

    /**
     * 获取菜单的所有父级菜单
     * @param
     * @return
     */
    List<SysMenu> getParentMenus(@Param("menuPath") String menuPath,@Param("rootMenuPath") String rootMenuPath);
}
