import { getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '供应商合作意愿',
            prop: 'sea.COOPERATE_WILLINGNESS_',
            type: 'select',
            options: getDictionaryByCode('zr-gyshzyy'),
            value: [],
            multiple: true
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'sea.SUPPLIER_NAME_',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '拟供应物资类型',
            prop: 'smc.CATEGORY_NAME_',
            type: 'input',
            value: '',
            span: 4
        },
        {
            title: '状态',
            prop: 'sea.STATUS_',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('gysgl-zt'),
            value: []
        },
        {
            title: '邀请时间',
            prop: 'sea.APPLY_DATE',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '拟供应物资类型',
            prop: 'materialCategoryName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供方基本情况调查表内容',
            prop: 'accessConfigurationName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '供应商合作意愿',
            prop: 'cooperateWillingness',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '状态',
            prop: 'status',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '邀请时间',
            prop: 'applyDate',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
