import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '物资分类编码',
            prop: 'catNo',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '物资分类名称',
            prop: 'catName',
            type: 'input',
            span: 4,
            value: ''
        },
    ]
    const columnsList: COption[] = [
        {
            title: '物资分类编码',
            prop: 'catNo',
            minWidth: 120,
            sortable: true
        },
        {
            title: '物资分类名称',
            prop: 'catName',
            minWidth: 200,
            sortable: true
        },
        {
            title: '绑定分类',
            prop: 'categoryName',
            minWidth: 200,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
