interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '客户名称',
            prop: 'se.ENTERPRISE_NAME_',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '申请时间',
            prop: 'se.APPLY_DATE',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '客户名称',
            prop: 'enterpriseName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '供应商等级',
            prop: 'gradingName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供应商类型',
            prop: 'catName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供应商状态',
            prop: 'type',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '企业类型',
            prop: 'innerFlag',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '年度评价等级',
            prop: 'zhpj',
            minWidth: 120,
            sortable: true
            // render: true
        },
        {
            title: '申请时间',
            prop: 'applyDate',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
