import request from '@/requset/axios'

// 用户菜单
export const userMenuQuery = () => {
    return new Promise((resolve, reject) => {
        request
            .get('/sys/sysMenu/v1/getCurrentUserMenu?menuAlias=front_menu')
            .then((res) => {
                resolve(res?.data?.value || [])
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 获取快捷菜单
export const getSwiftMenus = (parentMenuPath = '') => {
    return new Promise((resolve, reject) => {
        request
            .get('/sys/sysSwiftMenu/v1/getSwiftMenus?parentMenuPath=' + parentMenuPath)
            .then((res) => {
                resolve(res?.data || [])
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 新增快捷菜单
export const saveSwiftMenu = (menuAlias: string) => {
    return new Promise((resolve, reject) => {
        request
            .post('/sys/sysSwiftMenu/v1/save?menuAlias=' + menuAlias)
            .then((res) => resolve(res))
            .catch((err) => reject(err))
    })
}

// 删除快捷菜单
export const removeSwiftMenus = (menuAlias: string) => {
    return new Promise((resolve, reject) => {
        request
            .delete(`/sys/sysSwiftMenu/v1/removeSwiftMenus?menuAlias=${menuAlias}`)
            .then((res) => resolve(res))
            .catch((err) => reject(err))
    })
}

// 更改快捷菜单排序
export const updateSequence = (data) => {
    return new Promise((resolve, reject) => {
        request
            .post(`/sys/sysSwiftMenu/v1/updateSequence`, data)
            .then((res) => resolve(res))
            .catch((err) => reject(err))
    })
}
