import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object, role: string) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterprise/v1/queryPage?role=${role}`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 表格保存
export function dataSave(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterprise/v1/supplierSign`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 查看合同
export function viewContract(id: string) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizContract/v1/browseContract?threeContrId=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
