package com.artfess.bpm.plugin.usercalc.position.context;

import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.usercalc.position.def.PositionPluginDef;
import com.artfess.bpm.plugin.usercalc.position.runtime.PositionPlugin;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.w3c.dom.Element;

/**
 * 岗位作为流程审批人的上下文对象
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年11月18日
 */
public class PositionPluginContext extends AbstractUserCalcPluginContext {
	private static final long serialVersionUID = -5261531157333798291L;

	@Override
	public String getDescription() {
		String desc = "";
		PositionPluginDef def = (PositionPluginDef)this.getBpmPluginDef();
		if(def==null) return desc;
		String source = def.getSource();
		if("startSuper".equals(source)){
			desc = "发起人的上级岗位";
		}else if("prevSuper".equals(source)){
			desc = "上一步执行人的上级岗位";
		}else if("spec".equals(source)){
			desc = "[指定岗位]" + def.getPosName();
		}
		return desc;
	}

	@Override
	public String getTitle() {
		return "岗位";
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Class<? extends RunTimePlugin> getPluginClass() {
		return PositionPlugin.class;
	}
	
	/**
	 * <position posCode="" posName="" />
	 */
	@Override
	public String getPluginXml() {
		BpmPluginDef bpmPluginDef = getBpmPluginDef();
		PositionPluginDef def = (PositionPluginDef)bpmPluginDef;
		if(def==null) return "";
		String xml = String.format("<position xmlns=\"http://www.jee-soft.cn/bpm/plugins/userCalc/position\" logicCal=\"%s\"  extract=\"%s\" posCode=\"%s\" posName=\"%s\" source=\"%s\" />", 
								   def.getLogicCal(), def.getExtract(), def.getPosCode(), def.getPosName(), def.getSource());
		return xml;
	}
	
	@Override
	protected BpmPluginDef parseElement(Element element) {
		PositionPluginDef def = new PositionPluginDef();
		String source = element.getAttribute("source");
		String posCode = element.getAttribute("posCode");
		String posName = element.getAttribute("posName");
		def.setSource(source);
		def.setPosCode(posCode);
		def.setPosName(posName);
		return def;
	}

	@Override
	protected BpmPluginDef parseJson(ObjectNode pluginJson) throws Exception {
		PositionPluginDef def = new PositionPluginDef();
		String source = JsonUtil.getString(pluginJson, "source");
		String posCode = JsonUtil.getString(pluginJson, "posCode");
		String posName = JsonUtil.getString(pluginJson, "posName");
		def.setSource(source);
		def.setPosCode(posCode);
		def.setPosName(posName);
		return def;
	}
}
