package com.artfess.bpm.plugin.usercalc.org.runtime;

import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.BpmConstants;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.artfess.bpm.plugin.usercalc.org.def.OrgPluginDef;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.Org;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IOrgService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 部门作为审批人的插件
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年11月18日
 */
public class OrgPlugin extends AbstractUserCalcPlugin{

	@Override
	public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
		List<BpmIdentity> identityList=new ArrayList<BpmIdentity>();
		OrgPluginDef def = (OrgPluginDef)pluginDef;
		String orgCode = def.getOrgCode();
		String orgName = def.getOrgName();
		System.out.println("aa");
		if(StringUtil.isEmpty(orgCode)) return identityList;
		IOrgService orgEngine= pluginSession.getOrgEngine();
		Map<String, Object> vars= pluginSession.getVariables();
		boolean isReqUc = StringUtil.isEmpty((String)vars.get(BpmConstants.NOT_REQUEST_UC));
		IGroup group = null;
		if (isReqUc || ExtractType.EXACT_EXACT_USER.equals(def.getExtract())) {
			group = orgEngine.getUserGroupService().getGroupByIdOrCode(GroupTypeConstant.ORG.key(), orgCode);
		}else {
			group = buildOrgGroup(orgCode, orgName);
		}
		BpmIdentity bpmIdentity = getBpmIdentityConverter().convertGroup(group);
		identityList.add(bpmIdentity);
		return identityList;
	}
	
	private IGroup buildOrgGroup(String orgCode, String orgName) {
		Org org = new Org();
		org.setCode(orgCode);
		org.setName(orgName);
		return org;
	}
}
