package com.artfess.bpm.engine.task.skip;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.inst.ISkipCondition;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.model.process.task.SkipResult;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户为空时跳过。
 * @author ray
 *
 */
@Service
public class EmptyUserSkipCondition implements ISkipCondition {

	@Override
	public boolean canSkip(BpmTask task) {
		List<BpmIdentity> identityList = task.getIdentityList();
		if(BeanUtils.isEmpty(identityList)  ) return true;
		return false;
	}

	@Override
	public String getTitle() {
		return "用户为空跳过";
	}

	@Override
	public String getType() {
		return SkipResult.SKIP_EMPTY_USER;
	}

}
