package com.artfess.bpm.engine.graph;

import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.service.FlowStatusService;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.model.DefaultBpmProStatus;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultFlowStatusService implements FlowStatusService {
	
	@Resource
	BpmProStatusManager bpmProStatusManager;
	
	private Map<String, String> statusColorMap = new HashMap<String, String>();
	
	public void setStatusColor(Map<String, String> statusColorMap) {
		this.statusColorMap = statusColorMap;
	}


	@Override
	public Map<String, String> getProcessInstanceStatus(String bpmnInstId) {
		QueryFilter filter = QueryFilter.build().withDefaultPage();
		filter.addFilter("proc_inst_id_", bpmnInstId, QueryOP.EQUAL);
		List<DefaultBpmProStatus> statusList = bpmProStatusManager.query(filter).getRows();
		if(BeanUtils.isEmpty(statusList)){
			statusList = bpmProStatusManager.queryHistorys(bpmnInstId);
		}
		Map<String, String> colourMap = new HashMap<String, String>();
		if(BeanUtils.isEmpty(statusList)){
			return colourMap;
		}else{
			for(DefaultBpmProStatus bpmProStatus:statusList){
				String nodeId = bpmProStatus.getNodeId();
				String status = bpmProStatus.getStatus();
				String color = statusColorMap.get(status);
				colourMap.put(nodeId, color);
			}
		}
		return colourMap;
	}

}
