/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizUserTrainPlanDao;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizUserTrainPlanManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizUserTrainPlan;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizUserTrainPlanManagerImpl
extends BaseManagerImpl<BizUserTrainPlanDao, BizUserTrainPlan>
implements BizUserTrainPlanManager {
    @Autowired
    private BizExamPlanManager examPlanManager;
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Override
    public void importList(List<BizUserTrainPlan> list, String planId) {
        Assert.hasText((String)planId, (String)"\u8bf7\u9009\u62e9\u8981\u8003\u52e4\u7684\u8bad\u7ec3\u8ba1\u5212");
        BizExamPlan bizExamPlan = (BizExamPlan)this.examPlanManager.get((Serializable)((Object)planId));
        Assert.notNull((Object)((Object)bizExamPlan), (String)"\u8bad\u7ec3\u8ba1\u5212\u4e0d\u5b58\u5728");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        queryWrapper.eq((Object)"plan_id_", (Object)planId);
        List userTrainPlans = this.list((Wrapper)queryWrapper);
        ArrayList updateUsers = Lists.newArrayList();
        Map<String, BizUserTrainPlan> detailMap = userTrainPlans.stream().collect(Collectors.toMap(item -> item.getUserName(), item -> item));
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        AtomicReference<Long> num = new AtomicReference<Long>(0L);
        list.forEach(baseData -> {
            Assert.hasText((String)baseData.getUserName(), (String)"\u8bf7\u586b\u5199\u8003\u751f\u4fe1\u606f");
            Assert.notNull((Object)baseData.getHour(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u65f6\u957f");
            if (!CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(baseData.getOrgName())) {
                baseData.setOrgId(((OrgVo)((Object)((Object)orgMap.get(baseData.getOrgName())))).getId());
            }
            if (null != detailMap && null != detailMap.get(baseData.getUserName())) {
                BizUserTrainPlan userCheck = (BizUserTrainPlan)((Object)((Object)detailMap.get(baseData.getUserName())));
                if (!"1".equals(userCheck.getStatus())) {
                    num.getAndSet((Long)num.get() + 1L);
                }
                if (baseData.getHour().doubleValue() >= bizExamPlan.getHour().doubleValue()) {
                    userCheck.setStatus("2");
                } else {
                    userCheck.setStatus("1");
                }
                userCheck.setOrgId(baseData.getOrgId());
                userCheck.setHour(baseData.getHour());
                userCheck.setScore(baseData.getScore());
                updateUsers.add(userCheck);
            } else {
                num.getAndSet((Long)num.get() + 1L);
                baseData.setStatus("1");
                updateUsers.add(baseData);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)updateUsers)) {
            if (null == bizExamPlan.getRealityNum()) {
                bizExamPlan.setRealityNum(0L);
            }
            bizExamPlan.setRealityNum(bizExamPlan.getRealityNum() + num.get());
            this.examPlanManager.updateById((Object)bizExamPlan);
            this.saveOrUpdateBatch(updateUsers);
        }
    }
}

