/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImage(String imagePath) {
        InputStream is = ImageUtils.getFile(imagePath);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (Exception e) {
            log.error("\u56fe\u7247\u52a0\u8f7d\u5f02\u5e38 {}", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
    }

    public static InputStream getFile(String imagePath) {
        try {
            byte[] result = ImageUtils.readFile(imagePath);
            result = Arrays.copyOf(result, result.length);
            return new ByteArrayInputStream(result);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u56fe\u7247\u5f02\u5e38 {}", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String url) {
        byte[] byArray;
        InputStream in = null;
        Closeable baos = null;
        try {
            URL urlObj = new URL(url);
            URLConnection urlConnection = urlObj.openConnection();
            urlConnection.setConnectTimeout(3000);
            urlConnection.setReadTimeout(60000);
            urlConnection.setDoInput(true);
            in = urlConnection.getInputStream();
            byArray = IOUtils.toByteArray((InputStream)in);
            IOUtils.closeQuietly((Closeable)in);
        }
        catch (Exception e) {
            log.error("\u8bbf\u95ee\u6587\u4ef6\u5f02\u5e38 {}", (Throwable)e);
            byte[] byArray2 = null;
            return byArray2;
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(baos);
        }
        IOUtils.closeQuietly(baos);
        return byArray;
    }
}

