/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.i18n.support.service.impl;

import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.util.BeanUtils;
import com.artfess.i18n.persistence.manager.I18nMessageManager;
import com.artfess.i18n.persistence.model.I18nMessage;
import com.artfess.i18n.support.service.MessageService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RedisMessageService
implements MessageService {
    @Resource
    I18nMessageManager i18nMessageManager;
    @Resource
    CacheManager cacheManager;

    private Map<String, Map<String, String>> getFromI18nMessage(List<I18nMessage> list) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (I18nMessage i18nMessage : list) {
            String key = i18nMessage.getKey();
            String type = i18nMessage.getType();
            String value = i18nMessage.getValue();
            HashMap<String, String> subMap = (HashMap<String, String>)map.get(key);
            if (BeanUtils.isEmpty((Object)subMap)) {
                subMap = new HashMap<String, String>();
                map.put(key, subMap);
            }
            subMap.put(type, value);
        }
        return map;
    }

    private ICache getCache() {
        return this.cacheManager.getCache("bpm:i18n:resources", CacheKeyConst.EIP_I18N_RESOURCES_CACHESETTING);
    }

    @Override
    public String getMessage(String code, String type) {
        Map batchGet = this.getCache().getAll(Arrays.asList(code), type);
        return (String)batchGet.get(code);
    }

    @Override
    public Map<String, String> getMessages(List<String> codes, String type) {
        return this.getCache().getAll(codes, type);
    }

    @Override
    public void initMessage() {
        List list = this.i18nMessageManager.list();
        this.getCache().putAll(this.getFromI18nMessage(list));
    }

    @Override
    public void clearAllMessage() {
        this.getCache().clear();
    }

    @Override
    public void delByKey(String key) {
        this.getCache().evict((Object)key);
    }

    @Override
    public void hdel(String key, String field) {
        this.getCache().hdel(key, field);
    }
}

