/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.security.manager.BackupDatasourceManager;
import com.artfess.security.manager.BackupLogManager;
import com.artfess.security.model.BackupDatasource;
import com.artfess.security.model.BackupLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u5e93\u5907\u4efd\u7ba1\u7406"})
@RestController
@ApiGroup(group={"group_uc"})
@RequestMapping(value={"/uc/backupDatasource/v1/"})
public class BackupDatasourceController
extends BaseController<BackupDatasourceManager, BackupDatasource> {
    @Autowired
    private BackupDatasourceManager backupService;
    @Autowired
    private BackupLogManager logService;

    @PostMapping(value={"/insertBackupDatasource"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e")
    public CommonResult<String> insertBackupDatasource(@RequestBody BackupDatasource configEntity) {
        try {
            this.backupService.save((Object)configEntity);
            return new CommonResult(true, "\u65b0\u589e\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u65b0\u589e\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/updateBackupDatasource"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e")
    public CommonResult<String> updateBackupDatasource(@RequestBody BackupDatasource configEntity) {
        try {
            this.backupService.saveOrUpdate((Object)configEntity);
            return new CommonResult(true, "\u4fee\u6539\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fee\u6539\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteBackupDatasource"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e")
    @ApiImplicitParam(name="ids", value="\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6eID\uff0c\u6279\u91cf\u5220\u9664\u7528\u9017\u53f7\u9694\u5f00", required=true)
    public CommonResult<String> deleteBackupDatasource(@RequestParam String ids) {
        try {
            if (!StringUtils.isNotBlank((CharSequence)ids)) {
                return new CommonResult(false, "ids\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            List<String> idList = Arrays.asList(ids.split(","));
            this.backupService.removeByIds(idList);
            return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6279\u91cf\u5220\u9664\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/slicedQueryBackupDatasources"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u5217\u8868")
    public PageList<BackupDatasource> list(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BackupDatasource> queryFilter) {
        return this.backupService.query(queryFilter);
    }

    @PostMapping(value={"/slicedQueryBackupLog"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e\u65e5\u5fd7\u5217\u8868")
    public PageList<BackupLog> logList(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BackupLog> queryFilter) {
        return this.logService.query(queryFilter);
    }

    @PostMapping(value={"/loadBackupDatasource"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u6570\u636e\u4fdd\u5907\u4efd\u914d\u7f6e")
    public BackupDatasource loadBackupDatasource(String id) {
        BackupDatasource BackupDatasource2 = (BackupDatasource)((Object)this.backupService.getById((Serializable)((Object)id)));
        return BackupDatasource2;
    }

    @PostMapping(value={"/testDb"})
    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5")
    public CommonResult<String> testDb(String id) {
        try {
            String result = this.backupService.testDB(id);
            return new CommonResult(true, "\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f", (Object)result);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/testSystem"})
    @ApiOperation(value="\u6d4b\u8bd5\u670d\u52a1\u5668\u8fde\u63a5")
    public CommonResult<String> testSystem(String id) {
        try {
            String result = this.backupService.testSystem(id);
            return new CommonResult(true, "\u6d4b\u8bd5\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f", (Object)result);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6d4b\u8bd5\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/backUpDataBase"})
    @ApiOperation(value="\u624b\u52a8\u5907\u4efd")
    public CommonResult<String> backUpDataBase(String id) {
        try {
            this.backupService.backUpDataBase(id);
            return new CommonResult(true, "\u624b\u52a8\u5907\u4efd\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u624b\u52a8\u5907\u4efd\u5931\u8d25", (Object)"");
        }
    }

    @PostMapping(value={"/reduction"})
    @ApiOperation(value="\u624b\u52a8\u8fd8\u539f")
    public CommonResult<String> Reduction(String id) {
        try {
            this.backupService.Reduction(id);
            return new CommonResult(true, "\u624b\u52a8\u8fd8\u539f\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u624b\u52a8\u8fd8\u539f\u5931\u8d25", (Object)"");
        }
    }
}

