/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DESUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.security.dao.SysAuthorizationDao;
import com.artfess.security.manager.SysAuthorizationManager;
import com.artfess.security.model.SysAuthorization;
import com.artfess.security.util.AuthorCheck;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service(value="systemAuthorizationManager")
public class SysAuthorizationManagerImpl
extends BaseManagerImpl<SysAuthorizationDao, SysAuthorization>
implements SysAuthorizationManager {
    @Resource
    SysAuthorizationManager systemAuthorizationManager;
    @Resource
    SysAuthorizationDao sysAuthorizationDao;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    public static final String ROOT_PATH = System.getProperty("user.dir");
    public static final String DATA_TEMP_FILE = "tempFile";
    public static final String TEMP_DATA_EXCEL = ROOT_PATH + File.separator + "tempFile";

    @Override
    public String createDesFile(String id) throws Exception {
        File file;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id_", (Object)id);
        SysAuthorization entity = (SysAuthorization)((Object)this.systemAuthorizationManager.getOne((Wrapper)queryWrapper));
        entity.setDeptName(DESUtils.myEncrypt((String)entity.getDeptName()));
        entity.setVersionCode(DESUtils.myEncrypt((String)entity.getVersionCode()));
        entity.setType(DESUtils.myEncrypt((String)entity.getType()));
        entity.setInstallDate(DESUtils.myEncrypt((String)entity.getInstallDate()));
        entity.setEndDate(DESUtils.myEncrypt((String)entity.getEndDate()));
        entity.setUser(DESUtils.myEncrypt((String)entity.getUser()));
        entity.setOgnNum(DESUtils.myEncrypt((String)entity.getOgnNum()));
        entity.setTenantNum(DESUtils.myEncrypt((String)entity.getTenantNum()));
        entity.setUserNum(DESUtils.myEncrypt((String)entity.getUserNum()));
        entity.setSystemType(DESUtils.myEncrypt((String)entity.getSystemType()));
        String saveFile = TEMP_DATA_EXCEL + File.separator + id + ".lic";
        File file1 = new File(TEMP_DATA_EXCEL);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        if (!(file = new File(saveFile)).exists()) {
            file.createNewFile();
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
        oos.writeObject((Object)entity);
        oos.close();
        return saveFile;
    }

    public static void writeFile(String saveFile, String content) {
        try {
            FileWriter fw = new FileWriter(saveFile, true);
            fw.write(content);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writetxtfile(String filepath, String content) {
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter pw = new PrintWriter(filepath);
            pw.write(content);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readTxtFunc(String fileName) {
        String fileContent = "";
        try {
            File f = new File(fileName);
            if (f.isFile() && f.exists()) {
                String line;
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                BufferedReader reader = new BufferedReader(read);
                while ((line = reader.readLine()) != null) {
                    fileContent = fileContent + line;
                }
                read.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.print(fileContent);
        return fileContent;
    }

    @Override
    public Map<String, String> uploadSystemAuthCode(String path) {
        String content = SysAuthorizationManagerImpl.readTxtFunc(path);
        ClassPathResource resource = new ClassPathResource(AuthorCheck.FILE_PATH);
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SysAuthorizationManagerImpl.writetxtfile(file.getPath(), content);
        return AuthorCheck.getMapInfo();
    }

    @Override
    public void systemStartCreateFile() throws Exception {
        File file;
        SysAuthorization entity = new SysAuthorization();
        entity.setDeptName(DESUtils.myEncrypt((String)"\u8bd5\u7528\u5355\u4f4d"));
        entity.setVersionCode(DESUtils.myEncrypt((String)"\u8bd5\u7528\u7248"));
        entity.setType(DESUtils.myEncrypt((String)"1"));
        entity.setInstallDate(DESUtils.myEncrypt((String)DateUtils.formatDate()));
        entity.setEndDate(DESUtils.myEncrypt((String)DateUtils.formatAddDayDate((int)90)));
        entity.setUser(DESUtils.myEncrypt((String)"10"));
        entity.setOgnNum(DESUtils.myEncrypt((String)"1"));
        entity.setTenantNum(DESUtils.myEncrypt((String)"1"));
        entity.setUserNum(DESUtils.myEncrypt((String)"10"));
        entity.setSystemType(DESUtils.myEncrypt((String)"test"));
        String saveFile = AuthorCheck.FILE_PATH;
        File file1 = new File(TEMP_DATA_EXCEL);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        if ((file = new File(saveFile)).exists()) {
            return;
        }
        file.createNewFile();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
        oos.writeObject((Object)entity);
        oos.close();
    }

    @Override
    public String systemCreateFile() throws Exception {
        ObjectNode basic = this.systemConfigFeignService.getCommonBasicOne();
        if (basic != null) {
            SysAuthorization entity = new SysAuthorization();
            entity.setDeptName(DESUtils.myEncrypt((String)basic.get("sysName").asText()));
            entity.setVersionCode(DESUtils.myEncrypt((String)(null == basic.get("sysVersion") ? "\u8bd5\u7528\u7248" : basic.get("sysVersion").asText())));
            entity.setType(DESUtils.myEncrypt((String)"1"));
            entity.setTel(DESUtils.myEncrypt((String)(null == basic.get("sysCompanyPhone") ? "" : basic.get("sysCompanyPhone").asText())));
            entity.setInstallDate(DESUtils.myEncrypt((String)DateUtils.formatDate()));
            entity.setEndDate(DESUtils.myEncrypt((String)DateUtils.formatAddDayDate((int)90)));
            entity.setUser(DESUtils.myEncrypt((String)(null == basic.get("sysCompanyLegal") ? "\u4e34\u65f6\u7528\u6237" : basic.get("sysCompanyLegal").asText())));
            entity.setOgnNum(DESUtils.myEncrypt((String)"1"));
            entity.setTenantNum(DESUtils.myEncrypt((String)"1"));
            entity.setUserNum(DESUtils.myEncrypt((String)"10"));
            entity.setSystemType(DESUtils.myEncrypt((String)"test"));
            String saveFile = AuthorCheck.FILE_PATH_LIC;
            File file1 = new File(TEMP_DATA_EXCEL);
            if (!file1.exists()) {
                file1.mkdirs();
            }
            File file = new File(saveFile);
            file.createNewFile();
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
            oos.writeObject((Object)entity);
            oos.close();
            return saveFile;
        }
        return null;
    }

    @Override
    public SysAuthorization getByName(String deptName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)deptName), (Object)"DEPT_NAME_", (Object)deptName);
        List sysAuthorizations = this.sysAuthorizationDao.selectList((Wrapper)queryWrapper);
        if (sysAuthorizations.size() > 0) {
            return (SysAuthorization)((Object)sysAuthorizations.get(0));
        }
        return null;
    }
}

