/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.portal.kh.manager.KhResultManager;
import com.artfess.portal.kh.model.KhResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ee9\u6548\u8003\u6838-\u8003\u6838\u7ed3\u679c\u4fe1\u606f"})
@RequestMapping(value={"/kh/result/"})
@ApiGroup(group={"group_system"})
public class KhResultController
extends BaseController<KhResultManager, KhResult> {
    private static final Logger log = LoggerFactory.getLogger(KhResultController.class);

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public KhResult getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((KhResultManager)this.baseService).findById(id);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) KhResult t) {
        boolean result = ((KhResultManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) KhResult t) {
        boolean result = ((KhResultManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<KhResult> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<KhResult> queryFilter) {
        PageList query = ((KhResultManager)this.baseService).query(queryFilter);
        query.getRows().forEach(khResult -> {
            if (khResult.getStartDate().isAfter(LocalDate.now())) {
                khResult.setStatus("draft");
            }
        });
        return query;
    }
}

