/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.persistence.manager.impl;

import com.artfess.application.persistence.manager.ElaticsearchLogManager;
import com.artfess.es.unit.ElasticSearchApplication;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

@Service
public class ElaticsearchLogManagerImpl
implements ElaticsearchLogManager {
    private static String indexName = "bpm_log";
    @Resource
    private ElasticSearchApplication elasticSearchApplication;

    @Override
    public Map<String, Object> queryDataByQueryBuilder(Integer pageNum, Integer pageSize) {
        String name = "executionTime";
        SortOrder desc = SortOrder.DESC;
        return this.elasticSearchApplication.queryDataByQueryBuilder(indexName, null, name, desc, pageNum, pageSize);
    }

    @Override
    public List<Map<String, Object>> queryApplicationLogById(String id) {
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"bizNo", (String)id);
        return this.elasticSearchApplication.queryDataByQueryBuilder(indexName, (QueryBuilder)termQueryBuilder);
    }

    @Override
    public Map<String, Object> queryErrorByQueryBuilder(String user, String startDate, String endDate, Integer pageNum, Integer pageSize) {
        String name = "executionTime";
        BoolQueryBuilder queryBuilder3 = QueryBuilders.boolQuery();
        queryBuilder3.must((QueryBuilder)QueryBuilders.matchQuery((String)"logType", (Object)"\u9519\u8bef\u65e5\u5fd7"));
        if (user != null && !user.equals("")) {
            WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery((String)"operator", (String)("*" + user + "*"));
            queryBuilder3.must((QueryBuilder)wildcardQueryBuilder);
        }
        SortOrder desc = SortOrder.DESC;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            try {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"executionTime");
                SimpleDateFormat smf = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                rangeQueryBuilder.gte((Object)smf.parse(startDate).getTime());
                rangeQueryBuilder.lte((Object)smf.parse(endDate).getTime());
                queryBuilder3.must((QueryBuilder)rangeQueryBuilder);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        Map data = this.elasticSearchApplication.queryDataByQueryBuilder(indexName, (QueryBuilder)queryBuilder3, name, desc, pageNum, pageSize);
        return data;
    }

    @Override
    public Map<String, Object> queryBusinessByQueryBuilder(String logType, String user, String startDate, String endDate, Integer pageNum, Integer pageSize) throws IOException {
        String name = "executionTime";
        BoolQueryBuilder queryBuilder3 = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery((String)"operator", (String)("*" + user + "*"));
            queryBuilder3.must((QueryBuilder)wildcardQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)logType)) {
            queryBuilder3.must((QueryBuilder)QueryBuilders.matchQuery((String)"logType", (Object)logType));
        }
        SortOrder desc = SortOrder.DESC;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            try {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"executionTime");
                SimpleDateFormat smf = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                rangeQueryBuilder.gte((Object)smf.parse(startDate).getTime());
                rangeQueryBuilder.lte((Object)smf.parse(endDate).getTime());
                queryBuilder3.must((QueryBuilder)rangeQueryBuilder);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        Map data = this.elasticSearchApplication.queryDataByQueryBuilder(indexName, (QueryBuilder)queryBuilder3, name, desc, pageNum, pageSize);
        return data;
    }
}

