/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.impl.InnerHandler;
import com.artfess.application.model.MessageRead;
import com.artfess.application.model.SysMessage;
import com.artfess.application.params.MessaboxVo;
import com.artfess.application.persistence.manager.MessageReadManager;
import com.artfess.application.persistence.manager.SysMessageManager;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.jms.Notice;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msg/messageReceiver/v1"})
@Api(tags={"\u5185\u90e8\u6d88\u606f\u63a5\u6536"})
@ApiGroup(group={"group_application"})
public class MessageReceiverController
extends BaseController {
    @Resource
    MessageReadManager messageReadManager;
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    IUserService iUserService;
    @Resource
    private InnerHandler innerHandler;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u5217\u8868", httpMethod="POST", notes="\u6d88\u606f\u5217\u8868")
    public PageList<SysMessage> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<SysMessage> sysMessageList = this.sysMessageManager.getMsgByUserId(queryFilter);
        List list = sysMessageList.getRows();
        PageList newSysMessageList = new PageList();
        newSysMessageList.setRows(list);
        newSysMessageList.setPage(sysMessageList.getPage());
        newSysMessageList.setPageSize(sysMessageList.getPageSize());
        newSysMessageList.setTotal(sysMessageList.getTotal());
        return newSysMessageList;
    }

    @RequestMapping(value={"listNoPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u5217\u8868(\u4e0d\u5206\u9875)", httpMethod="POST", notes="\u6d88\u606f\u5217\u8868(\u4e0d\u5206\u9875)")
    public PageList<SysMessage> listJsonNoPage() throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("receiveTime", 1);
        queryFilter.setParams(map);
        PageList<SysMessage> sysMessageList = this.sysMessageManager.getMsgByUserId(queryFilter);
        List list = sysMessageList.getRows();
        PageList newSysMessageList = new PageList();
        newSysMessageList.setRows(list);
        newSysMessageList.setPage(sysMessageList.getPage());
        newSysMessageList.setPageSize(sysMessageList.getPageSize());
        newSysMessageList.setTotal(sysMessageList.getTotal());
        return newSysMessageList;
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u7f16\u8f91\u9875\u9762\u4fe1\u606f", httpMethod="GET", notes="\u6d88\u606f\u7f16\u8f91\u9875\u9762\u4fe1\u606f")
    public MessageRead edit(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) throws Exception {
        MessageRead messageRead = null;
        if (StringUtil.isNotEmpty((String)id)) {
            messageRead = (MessageRead)this.messageReadManager.get((Serializable)((Object)id));
        }
        return messageRead;
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u6d88\u606f\u660e\u7ec6\u9875\u9762")
    public SysMessage get(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) throws Exception {
        SysMessage sysMessage = (SysMessage)this.sysMessageManager.get((Serializable)((Object)id));
        IUser user = ContextUtil.getCurrentUser();
        this.messageReadManager.addMessageRead(id, user);
        this.sysMessageManager.update((Model)sysMessage);
        return sysMessage;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6d88\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u6d88\u606f\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4efb\u52a1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.sysMessageManager.removeByIds(Arrays.asList(aryIds));
        return new CommonResult(true, "\u5220\u9664\u6d88\u606f\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"getMessBoxInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5df2\u8bfb\u672a\u8bfb\u6d88\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5df2\u8bfb\u672a\u8bfb\u6d88\u606f")
    public MessaboxVo getMessBoxInfo(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account) throws Exception {
        IUser user = this.iUserService.getUserByAccount(account);
        int messCount = 0;
        int noReadMessCount = 0;
        if (BeanUtils.isNotEmpty((Object)user)) {
            QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
            PageList<SysMessage> sysMessageList = this.sysMessageManager.getMsgByUserId(queryFilter);
            messCount = (int)sysMessageList.getTotal();
            if (messCount > 0) {
                for (SysMessage message : sysMessageList.getRows()) {
                    if (!BeanUtils.isEmpty((Object)message.getReceiveTime())) continue;
                    ++noReadMessCount;
                }
            }
        }
        return new MessaboxVo(messCount, noReadMessCount);
    }

    @RequestMapping(value={"mark"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6807\u8bb0\u4e3a\u5df2\u8bfb", httpMethod="GET", notes="\u6807\u8bb0\u4e3a\u5df2\u8bfb")
    public CommonResult<String> mark(@ApiParam(name="ids", value="\u4efb\u52a1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        IUser user = ContextUtil.getCurrentUser();
        for (String string : aryIds) {
            this.messageReadManager.addMessageRead(string, user);
        }
        return new CommonResult(true, "\u6807\u8bb0\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"getMsgbadge"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672a\u8bfb\u6d88\u606f\u6570\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    public CommonResult<Integer> getMsgbadge() throws Exception {
        int badge = this.sysMessageManager.getNotReadMsgNum(ContextUtil.getCurrentUserId());
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)badge);
    }

    @RequestMapping(value={"sendInnerMessage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u9001\u7cfb\u7edf\u5185\u90e8\u6d88\u606f", httpMethod="POST", notes="\u53d1\u9001\u7cfb\u7edf\u5185\u90e8\u6d88\u606f")
    public CommonResult<String> sendInnerMessage(@ApiParam(name="Notice", value="\u6d88\u606f\u6a21\u7248", required=true) @RequestBody Notice notice) throws Exception {
        JmsMessage message = new JmsMessage();
        message.setSubject(notice.getSubject());
        message.setContent(notice.getContent());
        message.setType(notice.getTemplateType());
        message.setTypeKey(notice.getTemplateKey());
        message.setSender(notice.getSenderActor());
        message.setReceivers(notice.getReceiver());
        boolean send = this.innerHandler.send(message);
        if (!send) {
            return new CommonResult(false, "\u53d1\u9001\u5931\u8d25\uff01");
        }
        return new CommonResult(true, "\u53d1\u9001\u6210\u529f\uff01");
    }
}

